/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.TargetArtifactNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.TargetVariantNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ArtifactComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.PsRootNode;
import com.android.tools.idea.gradle.structure.model.PsModelNameComparator;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetArtifactsTreeStructure
extends AbstractBaseTreeStructure {
    @NotNull
    private final PsAndroidModule myModule;
    @NotNull
    private final PsRootNode myRootNode;

    TargetArtifactsTreeStructure(@NotNull PsAndroidModule module) {
        if (module == null) {
            TargetArtifactsTreeStructure.$$$reportNull$$$0(0);
        }
        this.myRootNode = new PsRootNode();
        this.myModule = module;
    }

    public Object getRootElement() {
        return this.myRootNode;
    }

    void displayTargetArtifacts(@Nullable PsAndroidDependency dependency) {
        if (dependency == null) {
            this.myRootNode.setChildren(Collections.emptyList());
            return;
        }
        ImmutableCollection<DependencyModel> parsedDependencies = dependency.getParsedModels();
        HashMultimap artifactsByVariant = HashMultimap.create();
        for (PsDependencyContainer container : dependency.getContainers()) {
            PsAndroidArtifact foundArtifact = container.findArtifact(this.myModule, false);
            if (foundArtifact == null || !foundArtifact.containsAny((Collection<DependencyModel>)parsedDependencies)) continue;
            PsVariant variant = foundArtifact.getParent();
            artifactsByVariant.put((Object)variant, (Object)foundArtifact);
            String name = foundArtifact.getResolvedName();
            if (!name.equals("_main_")) continue;
            variant.forEachArtifact(arg_0 -> TargetArtifactsTreeStructure.lambda$displayTargetArtifacts$0((Multimap)artifactsByVariant, variant, arg_0));
        }
        List variants = artifactsByVariant.keySet().stream().collect(Collectors.toList());
        if (variants.size() > 1) {
            Collections.sort(variants, new PsModelNameComparator());
        }
        ArrayList children = Lists.newArrayList();
        for (PsVariant variant : variants) {
            TargetVariantNode variantNode = new TargetVariantNode(variant);
            Collection artifacts = artifactsByVariant.get((Object)variant);
            List sorted = artifacts.stream().collect(Collectors.toList());
            if (sorted.size() > 1) {
                Collections.sort(sorted, ArtifactComparator.INSTANCE);
            }
            ArrayList artifactNodes = Lists.newArrayList();
            for (PsAndroidArtifact artifact : sorted) {
                artifactNodes.add(new TargetArtifactNode(artifact));
            }
            variantNode.setChildren(artifactNodes);
            children.add(variantNode);
        }
        this.myRootNode.setChildren(children);
    }

    private static /* synthetic */ void lambda$displayTargetArtifacts$0(Multimap artifactsByVariant, PsVariant variant, PsAndroidArtifact artifact) {
        artifactsByVariant.put((Object)variant, (Object)artifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/treeview/TargetArtifactsTreeStructure", "<init>"));
    }
}

