/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final DependenciesExtractor myDependenciesExtractor;
    @NotNull
    private final DependenciesModuleSetupStep myDependenciesModuleSetupStep;

    public ProjectStructureCleanupStep(@NotNull AndroidSdks androidSdks, @NotNull DependenciesExtractor dependenciesExtractor) {
        if (androidSdks == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(0);
        }
        if (dependenciesExtractor == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(1);
        }
        this(androidSdks, dependenciesExtractor, DependenciesModuleSetupStep.getInstance());
    }

    @VisibleForTesting
    ProjectStructureCleanupStep(@NotNull AndroidSdks androidSdks, @NotNull DependenciesExtractor dependenciesExtractor, @NotNull DependenciesModuleSetupStep dependenciesModuleSetupStep) {
        if (androidSdks == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(2);
        }
        if (dependenciesExtractor == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(3);
        }
        if (dependenciesModuleSetupStep == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(4);
        }
        this.myAndroidSdks = androidSdks;
        this.myDependenciesExtractor = dependenciesExtractor;
        this.myDependenciesModuleSetupStep = dependenciesModuleSetupStep;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(5);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(6);
        }
        HashSet<Sdk> androidSdks = new HashSet<Sdk>();
        for (Module module : ideModifiableModelsProvider.getModules()) {
            ModifiableRootModel rootModel = ideModifiableModelsProvider.getModifiableRootModel(module);
            this.adjustInterModuleDependencies(module, ideModifiableModelsProvider);
            Sdk sdk = rootModel.getSdk();
            if (sdk != null) {
                if (!this.myAndroidSdks.isAndroidSdk(sdk)) continue;
                androidSdks.add(sdk);
                continue;
            }
            NativeAndroidProject nativeAndroidProject = GradleUtil.getNativeAndroidProject(module);
            if (nativeAndroidProject != null) continue;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            rootModel.setSdk(jdk);
        }
        for (final Sdk sdk : androidSdks) {
            ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                public void execute() {
                    ProjectStructureCleanupStep.this.myAndroidSdks.refreshLibrariesIn(sdk);
                }
            });
        }
    }

    private void adjustInterModuleDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AndroidProject androidProject;
        if (module == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(8);
        }
        if ((androidProject = GradleUtil.getAndroidProject(module)) == null) {
            return;
        }
        this.updateAarDependencies(module, modelsProvider, androidProject);
    }

    private void updateAarDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        if (module == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(9);
        }
        if (modelsProvider == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(10);
        }
        if (androidProject == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(11);
        }
        ModifiableRootModel modifiableModel = modelsProvider.getModifiableRootModel(module);
        for (Module dependency : modifiableModel.getModuleDependencies()) {
            this.updateTransitiveDependencies(module, modelsProvider, androidProject, dependency);
        }
    }

    private void updateTransitiveDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull AndroidProject androidProject, @Nullable Module dependency) {
        if (module == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(12);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(13);
        }
        if (androidProject == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(14);
        }
        if (dependency == null) {
            return;
        }
        JavaFacet javaFacet = JavaFacet.getInstance(dependency);
        if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
            return;
        }
        AndroidProject dependencyAndroidProject = GradleUtil.getAndroidProject(dependency);
        if (dependencyAndroidProject != null) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(dependency);
            if (androidModel != null) {
                DependencySet dependencies = this.myDependenciesExtractor.extractFrom(androidModel);
                for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
                    this.myDependenciesModuleSetupStep.updateLibraryDependency(module, ideModifiableModelsProvider, libraryDependency, androidModel.getAndroidProject());
                }
                Project project = module.getProject();
                for (ModuleDependency moduleDependency : dependencies.onModules()) {
                    Module module1 = moduleDependency.getModule(project);
                    this.updateTransitiveDependencies(module, ideModifiableModelsProvider, androidProject, module1);
                }
            }
        } else {
            LibraryDependency backup = Projects.getModuleCompiledArtifact(dependency);
            if (backup != null) {
                this.myDependenciesModuleSetupStep.updateLibraryDependency(module, ideModifiableModelsProvider, backup, androidProject);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesExtractor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesModuleSetupStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModifiableModelsProvider";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustInterModuleDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAarDependencies";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTransitiveDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

