/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PluginVersionUpgrade {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PluginVersionUpgradeStep[] myUpgradeSteps;

    public PluginVersionUpgrade(@NotNull Project project) {
        if (project == null) {
            PluginVersionUpgrade.$$$reportNull$$$0(0);
        }
        this(project, PluginVersionUpgradeStep.getExtensions());
    }

    @VisibleForTesting
    PluginVersionUpgrade(@NotNull Project project, PluginVersionUpgradeStep ... upgradeSteps) {
        if (project == null) {
            PluginVersionUpgrade.$$$reportNull$$$0(1);
        }
        if (upgradeSteps == null) {
            PluginVersionUpgrade.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myUpgradeSteps = upgradeSteps;
    }

    public boolean checkAndPerformUpgrade() {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            PluginVersionUpgrade.getLog().warn("Unable to obtain application's Android Project");
            return false;
        }
        PluginVersionUpgrade.log(pluginInfo);
        for (PluginVersionUpgradeStep upgradeStep : this.myUpgradeSteps) {
            if (!upgradeStep.checkAndPerformUpgrade(this.myProject, pluginInfo)) continue;
            return true;
        }
        return false;
    }

    private static void log(@NotNull AndroidPluginInfo pluginInfo) {
        if (pluginInfo == null) {
            PluginVersionUpgrade.$$$reportNull$$$0(3);
        }
        GradleVersion current = pluginInfo.getPluginVersion();
        String recommended = pluginInfo.getPluginGeneration().getLatestKnownVersion();
        String message = String.format("Gradle model version: %1$s, recommended version for IDE: %2$s", current, recommended);
        PluginVersionUpgrade.getLog().info(message);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(PluginVersionUpgrade.class);
        if (logger == null) {
            PluginVersionUpgrade.$$$reportNull$$$0(4);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeSteps";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

