/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class JdkModuleSetupStep
extends AndroidModuleSetupStep {
    private static final String PROJECT_CONFIGURATION_SYNC_MESSAGE_GROUP = "Project Configuration";
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final CompileSdkVersionFinder myCompileSdkVersionFinder;

    public JdkModuleSetupStep() {
        this(IdeSdks.getInstance(), Jdks.getInstance());
    }

    @VisibleForTesting
    JdkModuleSetupStep(@NotNull IdeSdks ideSdks, @NotNull Jdks jdks) {
        if (ideSdks == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(0);
        }
        if (jdks == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(1);
        }
        this.myIdeSdks = ideSdks;
        this.myJdks = jdks;
        this.myCompileSdkVersionFinder = new CompileSdkVersionFinder();
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(2);
        }
        if (ideModelsProvider == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(3);
        }
        if (androidModel == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(4);
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.setUpInAndroidStudio(module, androidModel);
        }
    }

    @VisibleForTesting
    void setUpInAndroidStudio(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        Sdk jdk;
        AndroidProject androidProject;
        String compileTarget;
        AndroidVersion version;
        if (module == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(5);
        }
        if (androidModel == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(6);
        }
        if ((version = AndroidTargetHash.getPlatformVersion((String)(compileTarget = (androidProject = androidModel.getAndroidProject()).getCompileTarget()))) != null && version.getFeatureLevel() >= 21 && (jdk = this.myIdeSdks.getJdk()) != null && !this.myJdks.isApplicableJdk(jdk, LanguageLevel.JDK_1_7)) {
            Project project = module.getProject();
            String text = "compileSdkVersion " + compileTarget + " requires compiling with JDK 7 or newer.";
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            SyncMessage msg = buildFile != null ? this.reportWrongJdkError(project, text, buildFile) : this.reportWrongJdkError(project, text);
            SyncMessages.getInstance(project).report(msg);
            GradleSyncState.getInstance(project).getSummary().setWrongJdkFound(true);
        }
    }

    @NotNull
    private SyncMessage reportWrongJdkError(@NotNull Project project, @NotNull String text, @NotNull VirtualFile buildFile) {
        int offset;
        if (project == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (buildFile == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(9);
        }
        int line = -1;
        int column = -1;
        Document document = FileDocumentManager.getInstance().getDocument(buildFile);
        if (document != null && (offset = this.myCompileSdkVersionFinder.findOffsetIn(document.getText())) > -1 && (line = document.getLineNumber(offset)) > -1) {
            int lineStartOffset = document.getLineStartOffset(line);
            column = offset - lineStartOffset;
        }
        PositionInFile position = new PositionInFile(buildFile, line, column);
        SyncMessage msg = new SyncMessage(project, PROJECT_CONFIGURATION_SYNC_MESSAGE_GROUP, MessageType.ERROR, position, text);
        ArrayList quickFixes = Lists.newArrayList(this.myJdks.getWrongJdkQuickFixes(project));
        quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), "Open build.gradle File", line, column));
        msg.add(quickFixes);
        SyncMessage syncMessage = msg;
        if (syncMessage == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(10);
        }
        return syncMessage;
    }

    @NotNull
    private SyncMessage reportWrongJdkError(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(11);
        }
        if (text == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(12);
        }
        SyncMessage msg = new SyncMessage(PROJECT_CONFIGURATION_SYNC_MESSAGE_GROUP, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        msg.add(this.myJdks.getWrongJdkQuickFixes(project));
        SyncMessage syncMessage = msg;
        if (syncMessage == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(13);
        }
        return syncMessage;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("JDK setup" == null) {
            JdkModuleSetupStep.$$$reportNull$$$0(14);
        }
        return "JDK setup";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/JdkModuleSetupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/JdkModuleSetupStep";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "reportWrongJdkError";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUpInAndroidStudio";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportWrongJdkError";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class CompileSdkVersionFinder {
        CompileSdkVersionFinder() {
        }

        int findOffsetIn(@NotNull String buildFileContents) {
            if (buildFileContents == null) {
                CompileSdkVersionFinder.$$$reportNull$$$0(0);
            }
            GroovyLexer lexer = new GroovyLexer();
            lexer.start((CharSequence)buildFileContents);
            int end = -1;
            while (lexer.getTokenType() != null) {
                IElementType type = lexer.getTokenType();
                String text = lexer.getTokenText();
                if (type == GroovyTokenTypes.mIDENT) {
                    if ("compileSdkVersion".equals(text)) {
                        end = lexer.getTokenEnd();
                    } else if (end > -1) {
                        return end;
                    }
                } else if (type == TokenType.WHITE_SPACE && end > -1) {
                    ++end;
                } else if (end > -1) {
                    return end;
                }
                lexer.advance();
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileContents", "com/android/tools/idea/gradle/project/sync/setup/module/android/JdkModuleSetupStep$CompileSdkVersionFinder", "findOffsetIn"));
        }
    }
}

