/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidModuleDependenciesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final DependenciesExtractor myDependenciesExtractor;
    @NotNull
    private final AndroidModuleDependenciesSetup myDependenciesSetup;

    @NotNull
    public static DependenciesModuleSetupStep getInstance() {
        for (AndroidModuleSetupStep step : AndroidModuleSetupStep.getExtensions()) {
            if (!(step instanceof DependenciesModuleSetupStep)) continue;
            DependenciesModuleSetupStep dependenciesModuleSetupStep = (DependenciesModuleSetupStep)step;
            if (dependenciesModuleSetupStep == null) {
                DependenciesModuleSetupStep.$$$reportNull$$$0(0);
            }
            return dependenciesModuleSetupStep;
        }
        throw new AssertionError((Object)("Unable to find an instance of " + DependenciesModuleSetupStep.class.getSimpleName()));
    }

    public DependenciesModuleSetupStep(@NotNull DependenciesExtractor dependenciesExtractor, @NotNull LibraryFilePaths libraryFilePaths) {
        if (dependenciesExtractor == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(1);
        }
        if (libraryFilePaths == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(2);
        }
        this(dependenciesExtractor, new AndroidModuleDependenciesSetup(libraryFilePaths));
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull DependenciesExtractor dependenciesExtractor, @NotNull AndroidModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesExtractor == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(3);
        }
        if (dependenciesSetup == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(4);
        }
        this.myDependenciesExtractor = dependenciesExtractor;
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(5);
        }
        if (ideModelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(6);
        }
        if (androidModel == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(7);
        }
        AndroidProject androidProject = androidModel.getAndroidProject();
        DependencySet dependencies = this.myDependenciesExtractor.extractFrom(androidModel);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            this.updateLibraryDependency(module, ideModelsProvider, libraryDependency, androidProject);
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(module, ideModelsProvider, moduleDependency, androidProject);
        }
        this.addExtraSdkLibrariesAsDependencies(module, ideModelsProvider, androidProject);
        Collection<SyncIssue> syncIssues = androidModel.getSyncIssues();
        if (syncIssues != null) {
            SyncIssuesReporter.getInstance().report(syncIssues, module);
        } else {
            Collection collection = androidProject.getUnresolvedDependencies();
            UnresolvedDependenciesReporter.getInstance().report(collection, module);
        }
    }

    private void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(9);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(10);
        }
        if (androidProject == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(11);
        }
        Module moduleDependency = dependency.getModule(modelsProvider);
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setScope(dependency.getScope());
            orderEntry.setExported(true);
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        DependencySetupErrors dependencySetupErrors = DependencySetupErrors.getInstance(module.getProject());
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        dependencySetupErrors.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            this.updateLibraryDependency(module, modelsProvider, compiledArtifact, androidProject);
        }
    }

    public void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(12);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(13);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(14);
        }
        if (androidProject == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(15);
        }
        String name = dependency.getName();
        DependencyScope scope = dependency.getScope();
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, dependency.getArtifactPath(), dependency.getPaths(LibraryDependency.PathType.BINARY), dependency.getPaths(LibraryDependency.PathType.DOCUMENTATION));
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        if (contentEntries.length > 0) {
            for (File binaryPath : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                ContentEntry parentContentEntry;
                File parent = binaryPath.getParentFile();
                if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
                parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
            }
        }
    }

    private void addExtraSdkLibrariesAsDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        SdkAdditionalData data;
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(16);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(17);
        }
        if (androidProject == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(18);
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        Sdk sdk = moduleModel.getSdk();
        assert (sdk != null);
        String suffix = null;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) {
            VirtualFile[] androidSdkData = (VirtualFile[])data;
            suffix = androidSdkData.getBuildTargetHashString();
        }
        if (suffix == null) {
            suffix = androidProject.getCompileTarget();
        }
        HashSet currentIdeSdkFilePaths = Sets.newHashSetWithExpectedSize((int)5);
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            currentIdeSdkFilePaths.add(sdkFilePath.getPath());
        }
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String library : bootClasspath) {
            if (!StringUtil.isNotEmpty((String)library) || currentIdeSdkFilePaths.contains(library)) continue;
            File binaryPath = new File(library);
            String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)library);
            name = name + "-" + suffix;
            this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, DependencyScope.COMPILE, binaryPath);
        }
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Android dependencies setup" == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(19);
        }
        return "Android dependencies setup";
    }

    @Override
    public boolean invokeOnBuildVariantChange() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesExtractor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFilePaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesSetup";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleDependency";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraryDependency";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExtraSdkLibrariesAsDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

