/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class ModuleSetup {
    @NotNull
    private final IdeModifiableModelsProvider myIdeModelsProvider;
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final GradleModuleSetup myGradleModuleSetup;
    @NotNull
    private final AndroidModuleSetup myAndroidModuleSetup;
    @NotNull
    private final NdkModuleSetup myNdkModuleSetup;
    @NotNull
    private final JavaModuleSetup myJavaModuleSetup;

    public ModuleSetup(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (ideModelsProvider == null) {
            ModuleSetup.$$$reportNull$$$0(0);
        }
        this(ideModelsProvider, new VariantSelector(), new GradleModuleSetup(), new AndroidModuleSetup(), new NdkModuleSetup(), new JavaModuleSetup());
    }

    @VisibleForTesting
    ModuleSetup(@NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull VariantSelector variantSelector, @NotNull GradleModuleSetup gradleModuleSetup, @NotNull AndroidModuleSetup androidModuleSetup, @NotNull NdkModuleSetup ndkModuleSetup, @NotNull JavaModuleSetup javaModuleSetup) {
        if (ideModelsProvider == null) {
            ModuleSetup.$$$reportNull$$$0(1);
        }
        if (variantSelector == null) {
            ModuleSetup.$$$reportNull$$$0(2);
        }
        if (gradleModuleSetup == null) {
            ModuleSetup.$$$reportNull$$$0(3);
        }
        if (androidModuleSetup == null) {
            ModuleSetup.$$$reportNull$$$0(4);
        }
        if (ndkModuleSetup == null) {
            ModuleSetup.$$$reportNull$$$0(5);
        }
        if (javaModuleSetup == null) {
            ModuleSetup.$$$reportNull$$$0(6);
        }
        this.myIdeModelsProvider = ideModelsProvider;
        this.myVariantSelector = variantSelector;
        this.myGradleModuleSetup = gradleModuleSetup;
        this.myAndroidModuleSetup = androidModuleSetup;
        this.myNdkModuleSetup = ndkModuleSetup;
        this.myJavaModuleSetup = javaModuleSetup;
    }

    public void setUpModule(@NotNull Module module, @NotNull SyncAction.ModuleModels models, @NotNull ProgressIndicator indicator) {
        if (module == null) {
            ModuleSetup.$$$reportNull$$$0(7);
        }
        if (models == null) {
            ModuleSetup.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            ModuleSetup.$$$reportNull$$$0(9);
        }
        boolean isProjectRootFolder = false;
        File gradleSettingsFile = new File(ModuleSetup.getModulePath(module), "settings.gradle");
        if (gradleSettingsFile.isFile() && !models.hasModel(AndroidProject.class) && !models.hasModel(NativeAndroidProject.class)) {
            isProjectRootFolder = true;
        }
        this.myGradleModuleSetup.setUpModule(module, this.myIdeModelsProvider, models);
        AndroidProject androidProject = models.findModel(AndroidProject.class);
        if (androidProject != null) {
            AndroidModuleModel androidModel = this.createAndroidModel(module, androidProject);
            if (androidModel != null) {
                this.myAndroidModuleSetup.setUpModule(module, this.myIdeModelsProvider, androidModel, models, indicator);
            } else {
                this.removeAndroidFacetFrom(module);
                this.setUpJavaModule(module, models, indicator, true);
            }
            return;
        }
        this.removeAndroidFacetFrom(module);
        NativeAndroidProject nativeAndroidProject = models.findModel(NativeAndroidProject.class);
        if (nativeAndroidProject != null) {
            NdkModuleModel ndkModuleModel = new NdkModuleModel(module.getName(), ModuleSetup.getModulePath(module), nativeAndroidProject);
            this.myNdkModuleSetup.setUpModule(module, this.myIdeModelsProvider, ndkModuleModel, models, indicator);
            return;
        }
        Facets.removeAllFacets(this.myIdeModelsProvider.getModifiableFacetModel(module), NdkFacet.getFacetTypeId());
        if (!isProjectRootFolder) {
            this.setUpJavaModule(module, models, indicator, false);
        }
    }

    private void removeAndroidFacetFrom(@NotNull Module module) {
        if (module == null) {
            ModuleSetup.$$$reportNull$$$0(10);
        }
        Facets.removeAllFacets(this.myIdeModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
    }

    @Nullable
    private AndroidModuleModel createAndroidModel(@NotNull Module module, @NotNull AndroidProject androidProject) {
        Variant variantToSelect;
        if (module == null) {
            ModuleSetup.$$$reportNull$$$0(11);
        }
        if (androidProject == null) {
            ModuleSetup.$$$reportNull$$$0(12);
        }
        if ((variantToSelect = this.myVariantSelector.findVariantToSelect(androidProject)) != null) {
            return new AndroidModuleModel(module.getName(), ModuleSetup.getModulePath(module), androidProject, variantToSelect.getName());
        }
        return null;
    }

    @NotNull
    private static File getModulePath(@NotNull Module module) {
        if (module == null) {
            ModuleSetup.$$$reportNull$$$0(13);
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File file = moduleFilePath.getParentFile();
        if (file == null) {
            ModuleSetup.$$$reportNull$$$0(14);
        }
        return file;
    }

    private void setUpJavaModule(@NotNull Module module, @NotNull SyncAction.ModuleModels models, @NotNull ProgressIndicator indicator, boolean androidProjectWithoutVariants) {
        if (module == null) {
            ModuleSetup.$$$reportNull$$$0(15);
        }
        if (models == null) {
            ModuleSetup.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            ModuleSetup.$$$reportNull$$$0(17);
        }
        ModuleExtendedModel javaModel = models.findModel(ModuleExtendedModel.class);
        JavaModuleModel javaModuleModel = new JavaModuleModel(models.getModule(), javaModel, androidProjectWithoutVariants);
        this.myJavaModuleSetup.setUpModule(module, this.myIdeModelsProvider, javaModuleModel, models, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModuleSetup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleSetup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleSetup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleSetup";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAndroidFacetFrom";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModulePath";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setUpJavaModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

