/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.messages;

import com.android.tools.idea.gradle.notification.QuickFixNotificationListener;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncMessages {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    @NotNull
    public static SyncMessages getInstance(@NotNull Project project) {
        if (project == null) {
            SyncMessages.$$$reportNull$$$0(0);
        }
        SyncMessages syncMessages = (SyncMessages)ServiceManager.getService((Project)project, SyncMessages.class);
        if (syncMessages == null) {
            SyncMessages.$$$reportNull$$$0(1);
        }
        return syncMessages;
    }

    public SyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            SyncMessages.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SyncMessages.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getErrorCount() {
        return this.getMessageCount(NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            SyncMessages.$$$reportNull$$$0(4);
        }
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public boolean isEmpty() {
        return this.getMessageCount((NotificationCategory)null) == 0;
    }

    private int getMessageCount(@Nullable NotificationCategory category) {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, category, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public void removeProjectMessages() {
        this.removeMessages("Project Structure Issues", "Missing Dependencies", "Variant Selection Conflicts", "Generated Sources", "Gradle Sync Issues");
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            SyncMessages.$$$reportNull$$$0(5);
        }
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, GradleUtil.GRADLE_SYSTEM_ID);
        }
    }

    public void report(@NotNull SyncMessage message) {
        if (message == null) {
            SyncMessages.$$$reportNull$$$0(6);
        }
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            SyncMessages.$$$reportNull$$$0(7);
        }
        if (text == null) {
            SyncMessages.$$$reportNull$$$0(8);
        }
        if (category == null) {
            SyncMessages.$$$reportNull$$$0(9);
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            NotificationData notificationData = new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
            if (notificationData == null) {
                SyncMessages.$$$reportNull$$$0(10);
            }
            return notificationData;
        }
        NotificationData notificationData = new NotificationData(title, text, category, source);
        if (notificationData == null) {
            SyncMessages.$$$reportNull$$$0(11);
        }
        return notificationData;
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            SyncMessages.$$$reportNull$$$0(12);
        }
        if (text == null) {
            SyncMessages.$$$reportNull$$$0(13);
        }
        if (quickFixes == null) {
            SyncMessages.$$$reportNull$$$0(14);
        }
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            SyncMessages.$$$reportNull$$$0(15);
        }
        if (quickFixes == null) {
            SyncMessages.$$$reportNull$$$0(16);
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notification) {
        if (notification == null) {
            SyncMessages.$$$reportNull$$$0(17);
        }
        this.myNotificationManager.showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/messages/SyncMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/messages/SyncMessages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeMessages";
                break;
            }
            case 6: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

