/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OldAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern PATTERN = Pattern.compile("The android gradle plugin version .+ is too old, please update to the latest version.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(2);
        }
        if (OldAndroidPluginErrorHandler.isMatching(text = rootCause.getMessage())) {
            OldAndroidPluginErrorHandler.updateUsageTracker();
            return Joiner.on((char)'\n').join((Iterable)Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text));
        }
        return null;
    }

    @VisibleForTesting
    static boolean isMatching(String text) {
        if (StringUtil.isNotEmpty((String)text)) {
            String firstLine = OldAndroidPluginErrorHandler.getFirstLineMessage(text);
            if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
                return true;
            }
            return PATTERN.matcher(firstLine).matches();
        }
        return false;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(4);
        }
        if (text == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(5);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        AndroidPluginInfo result = AndroidPluginInfo.searchInBuildFilesOnly(project);
        if (result != null && result.getPluginBuildFile() != null) {
            hyperlinks.add(new OpenFileHyperlink(result.getPluginBuildFile().getPath()));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

