/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectCleanUpTask;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

class GradleDistributionCleanUpTask
extends ProjectCleanUpTask {
    private static final String GRADLE_SYNC_MSG_TITLE = "Gradle Sync";

    GradleDistributionCleanUpTask() {
    }

    @Override
    void cleanUp(@NotNull Project project) {
        boolean usingWrapper;
        if (project == null) {
            GradleDistributionCleanUpTask.$$$reportNull$$$0(0);
        }
        GradleProjectSettings gradleSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && gradleWrapper != null;
        if (usingWrapper && gradleSettings != null) {
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (gradleWrapper == null && gradleSettings != null) {
            this.createWrapperIfNecessary(project, gradleSettings, distributionType);
        }
    }

    private boolean createWrapperIfNecessary(@NotNull Project project, @NotNull GradleProjectSettings gradleSettings, @Nullable DistributionType distributionType) {
        ChooseGradleHomeDialog dialog;
        if (project == null) {
            GradleDistributionCleanUpTask.$$$reportNull$$$0(1);
        }
        if (gradleSettings == null) {
            GradleDistributionCleanUpTask.$$$reportNull$$$0(2);
        }
        boolean createWrapper = false;
        boolean chooseLocalGradleHome = false;
        if (distributionType == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return true;
            }
            String msg = GradleDistributionCleanUpTask.createUseWrapperQuestion("Gradle settings for this project are not configured yet.");
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            createWrapper = answer == 0;
        } else if (distributionType == DistributionType.DEFAULT_WRAPPED) {
            createWrapper = true;
        } else if (distributionType == DistributionType.LOCAL) {
            String gradleHome = gradleSettings.getGradleHome();
            String msg = null;
            if (StringUtil.isEmpty((String)gradleHome)) {
                msg = GradleDistributionCleanUpTask.createUseWrapperQuestion("The path of the local Gradle distribution to use is not set.");
            } else {
                File gradleHomePath = new File(FileUtil.toSystemDependentName((String)gradleHome));
                if (!gradleHomePath.isDirectory()) {
                    String reason = String.format("The path\n'%1$s'\n, set as a local Gradle distribution, does not belong to an existing directory.", gradleHomePath.getPath());
                    msg = GradleDistributionCleanUpTask.createUseWrapperQuestion(reason);
                } else {
                    GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(gradleHomePath);
                    if (gradleVersion == null) {
                        String reason = String.format("The path\n'%1$s'\n, does not belong to a Gradle distribution.", gradleHomePath.getPath());
                        msg = GradleDistributionCleanUpTask.createUseWrapperQuestion(reason);
                    } else if (!GradleUtil.isSupportedGradleVersion(gradleVersion)) {
                        String reason = String.format("Gradle version %1$s is not supported.", gradleHomePath.getPath());
                        msg = GradleDistributionCleanUpTask.createUseWrapperQuestion(reason);
                    }
                }
            }
            if (msg != null) {
                int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                createWrapper = answer == 0;
                boolean bl = chooseLocalGradleHome = !createWrapper;
            }
        }
        if (createWrapper) {
            File projectPath = Projects.getBaseDirPath(project);
            File gradleDirPath = new File(projectPath, "gradle");
            if (!FileUtil.delete((File)gradleDirPath)) {
                return true;
            }
            try {
                GradleWrapper.create(projectPath);
                if (distributionType == null) {
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                return true;
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).info("Failed to create Gradle wrapper for project '" + project.getName() + "'", (Throwable)e);
            }
        } else if ((distributionType == null || chooseLocalGradleHome) && (dialog = new ChooseGradleHomeDialog()).showAndGet()) {
            String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
            gradleSettings.setGradleHome(enteredGradleHomePath);
            gradleSettings.setDistributionType(DistributionType.LOCAL);
            return true;
        }
        return false;
    }

    @NotNull
    private static String createUseWrapperQuestion(@NotNull String reason) {
        if (reason == null) {
            GradleDistributionCleanUpTask.$$$reportNull$$$0(3);
        }
        String string = reason + "\n\nWould you like the project to use the Gradle wrapper?\n(The wrapper will automatically download the latest supported Gradle version).\n\nClick 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
        if (string == null) {
            GradleDistributionCleanUpTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/cleanup/GradleDistributionCleanUpTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/cleanup/GradleDistributionCleanUpTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseWrapperQuestion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanUp";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUseWrapperQuestion";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

