/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleFactory;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleDisposer;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncAction.ProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void commit(boolean var1);

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        private static Key<SyncAction.ModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final IdeInfo myIdeInfo;
        @NotNull
        private final GradleSyncState mySyncState;
        @NotNull
        private final ModuleFactory myModuleFactory;
        @NotNull
        private final ModuleSetup myModuleSetup;
        @NotNull
        private final AndroidModuleValidator.Factory myModuleValidatorFactory;
        @NotNull
        private final ModuleDisposer myModuleDisposer;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            if (project == null) {
                ProjectSetupImpl.$$$reportNull$$$0(0);
            }
            if (modelsProvider == null) {
                ProjectSetupImpl.$$$reportNull$$$0(1);
            }
            this(project, modelsProvider, IdeInfo.getInstance(), GradleSyncState.getInstance(project), new ModuleFactory(project, modelsProvider), new ModuleSetup(modelsProvider), new AndroidModuleValidator.Factory(), new ModuleDisposer());
        }

        @VisibleForTesting
        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull IdeInfo ideInfo, @NotNull GradleSyncState syncState, @NotNull ModuleFactory moduleFactory, @NotNull ModuleSetup moduleSetup, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull ModuleDisposer moduleDisposer) {
            if (project == null) {
                ProjectSetupImpl.$$$reportNull$$$0(2);
            }
            if (modelsProvider == null) {
                ProjectSetupImpl.$$$reportNull$$$0(3);
            }
            if (ideInfo == null) {
                ProjectSetupImpl.$$$reportNull$$$0(4);
            }
            if (syncState == null) {
                ProjectSetupImpl.$$$reportNull$$$0(5);
            }
            if (moduleFactory == null) {
                ProjectSetupImpl.$$$reportNull$$$0(6);
            }
            if (moduleSetup == null) {
                ProjectSetupImpl.$$$reportNull$$$0(7);
            }
            if (moduleValidatorFactory == null) {
                ProjectSetupImpl.$$$reportNull$$$0(8);
            }
            if (moduleDisposer == null) {
                ProjectSetupImpl.$$$reportNull$$$0(9);
            }
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myIdeInfo = ideInfo;
            this.mySyncState = syncState;
            this.myModuleFactory = moduleFactory;
            this.myModuleSetup = moduleSetup;
            this.myModuleValidatorFactory = moduleValidatorFactory;
            this.myModuleDisposer = moduleDisposer;
        }

        @Override
        void setUpProject(@NotNull SyncAction.ProjectModels models, @NotNull ProgressIndicator indicator) {
            if (models == null) {
                ProjectSetupImpl.$$$reportNull$$$0(10);
            }
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(11);
            }
            this.createModules(models, indicator);
            this.setUpModules(indicator);
        }

        private void createModules(@NotNull SyncAction.ProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            if (projectModels == null) {
                ProjectSetupImpl.$$$reportNull$$$0(12);
            }
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(13);
            }
            indicator.setText2("Creating modules");
            for (IdeaModule ideaModule : projectModels.getProject().getModules()) {
                SyncAction.ModuleModels moduleModels = projectModels.getModels(ideaModule);
                Module module = this.myModuleFactory.createModule(ideaModule, moduleModels);
                module.putUserData(MODULE_GRADLE_MODELS_KEY, (Object)moduleModels);
            }
        }

        private void setUpModules(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(14);
            }
            ArrayList<Module> modulesToDispose = new ArrayList<Module>();
            AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
            for (Module module : this.myModelsProvider.getModules()) {
                SyncAction.ModuleModels moduleModels = (SyncAction.ModuleModels)module.getUserData(MODULE_GRADLE_MODELS_KEY);
                if (moduleModels == null) {
                    if (!this.myIdeInfo.isAndroidStudio() && !this.mySyncState.lastSyncFailedOrHasIssues()) continue;
                    modulesToDispose.add(module);
                    continue;
                }
                this.myModuleSetup.setUpModule(module, moduleModels, indicator);
                AndroidModuleModel androidModel = this.findAndroidModel(module);
                if (androidModel != null) {
                    moduleValidator.validate(module, androidModel);
                }
                module.putUserData(MODULE_GRADLE_MODELS_KEY, null);
            }
            moduleValidator.fixAndReportFoundIssues();
            this.myModuleDisposer.disposeModulesAndMarkImlFilesForDeletion(modulesToDispose, this.myProject, this.myModelsProvider);
        }

        @Nullable
        private AndroidModuleModel findAndroidModel(@NotNull Module module) {
            AndroidFacet facet;
            if (module == null) {
                ProjectSetupImpl.$$$reportNull$$$0(15);
            }
            return (facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID)) != null ? AndroidModuleModel.get(facet) : null;
        }

        @Override
        public void commit(boolean synchronous) {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.dispose();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelsProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "syncState";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFactory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSetup";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleValidatorFactory";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDisposer";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectModels";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpProject";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createModules";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpModules";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findAndroidModel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ProjectSetupImpl projectSetupImpl = new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project));
            if (projectSetupImpl == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return projectSetupImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ProjectSetup$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ProjectSetup$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

