/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final GradleExecutionHelper myHelper;

    NewGradleSync() {
        this(new CommandLineArgs(true), new ProjectSetup.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectSetup.Factory projectSetupFactory) {
        if (commandLineArgs == null) {
            NewGradleSync.$$$reportNull$$$0(0);
        }
        if (projectSetupFactory == null) {
            NewGradleSync.$$$reportNull$$$0(1);
        }
        this.myHelper = new GradleExecutionHelper();
        this.myCommandLineArgs = commandLineArgs;
        this.myProjectSetupFactory = projectSetupFactory;
    }

    @Override
    public void sync(final @NotNull Project project, @NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener) {
        Object task;
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(2);
        }
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(3);
        }
        String title = String.format("Syncing project '%1$s' with Gradle", project.getName());
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        switch (executionMode) {
            case MODAL_SYNC: {
                task = new Task.Modal(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(project, indicator, listener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync$1", "run"));
                    }
                };
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                task = new Task.Backgroundable(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(project, indicator, listener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync$2", "run"));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
            }
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ((Task)task).queue());
    }

    private void sync(@NotNull Project project, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(5);
        }
        Callback callback = this.sync(project);
        callback.doWhenDone(() -> {
            if (project == null) {
                NewGradleSync.$$$reportNull$$$0(23);
            }
            if (indicator == null) {
                NewGradleSync.$$$reportNull$$$0(24);
            }
            this.onSyncFinished(project, callback, indicator, syncListener);
        }).doWhenRejected(() -> {
            if (project == null) {
                NewGradleSync.$$$reportNull$$$0(22);
            }
            NewGradleSync.onSyncFailed(project, callback, syncListener);
        });
    }

    @VisibleForTesting
    @NotNull
    Callback sync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(6);
        }
        Callback callback = new Callback();
        if (project.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", project.getName()));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project, NewGradleSync.useEmbeddedGradle());
        Function syncFunction = connection -> {
            if (project == null) {
                NewGradleSync.$$$reportNull$$$0(21);
            }
            ArrayList modelTypes = Lists.newArrayList((Object[])new Class[]{AndroidProject.class, NativeAndroidProject.class, GradleBuild.class, ModuleExtendedModel.class});
            BuildActionExecuter executor = connection.action((BuildAction)new SyncAction(modelTypes));
            ExternalSystemTaskNotificationListenerAdapter listener = new ExternalSystemTaskNotificationListenerAdapter(){};
            List<String> commandLineArgs = this.myCommandLineArgs.get(project);
            ExternalSystemTaskId id = NewGradleSync.createId(project);
            GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)listener, Collections.emptyList(), commandLineArgs, (ProjectConnection)connection);
            CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
            executor.withCancellationToken(cancellationTokenSource.token());
            try {
                SyncAction.ProjectModels models = (SyncAction.ProjectModels)executor.run();
                callback.setDone(models);
            }
            catch (RuntimeException e) {
                callback.setRejected(e);
            }
            return null;
        };
        this.myHelper.execute(Projects.getBaseDirPath(project).getPath(), executionSettings, syncFunction);
        Callback callback2 = callback;
        if (callback2 == null) {
            NewGradleSync.$$$reportNull$$$0(7);
        }
        return callback2;
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(8);
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        if (externalSystemTaskId == null) {
            NewGradleSync.$$$reportNull$$$0(9);
        }
        return externalSystemTaskId;
    }

    private static boolean useEmbeddedGradle() {
        return false;
    }

    private void onSyncFinished(@NotNull Project project, @NotNull Callback callback, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        SyncAction.ProjectModels models;
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            NewGradleSync.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(12);
        }
        if ((models = callback.getModels()) != null) {
            try {
                ProjectSetup projectSetup = this.myProjectSetupFactory.create(project);
                projectSetup.setUpProject(models, indicator);
                projectSetup.commit(true);
                if (syncListener != null) {
                    syncListener.syncSucceeded(project);
                }
                GradleSyncState.getInstance(project).syncEnded();
            }
            catch (Throwable e) {
                NewGradleSync.notifyAndLogSyncError(project, NewGradleSync.nullToUnknownErrorCause(NewGradleSync.getRootCauseMessage(e)), syncListener);
            }
        } else {
            NewGradleSync.notifyAndLogSyncError(project, "Gradle did not return any project models", syncListener);
        }
    }

    private static void notifyAndLogSyncError(@NotNull Project project, @NotNull String errorMessage, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(13);
        }
        if (errorMessage == null) {
            NewGradleSync.$$$reportNull$$$0(14);
        }
        if (syncListener != null) {
            syncListener.syncFailed(project, errorMessage);
        }
        NewGradleSync.logSyncFailure(errorMessage);
    }

    private static void onSyncFailed(@NotNull Project project, @NotNull Callback callback, @Nullable GradleSyncListener syncListener) {
        Throwable error;
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            NewGradleSync.$$$reportNull$$$0(16);
        }
        String errorMessage = (error = callback.getSyncError()) != null ? NewGradleSync.getRootCauseMessage(error) : callback.getError();
        errorMessage = NewGradleSync.nullToUnknownErrorCause(errorMessage);
        if (syncListener != null) {
            syncListener.syncFailed(project, errorMessage);
        }
        GradleSyncState.getInstance(project).syncFailed(errorMessage);
        if (error != null) {
            NewGradleSync.getLog().warn("Gradle sync failed", error);
        } else {
            NewGradleSync.logSyncFailure(errorMessage);
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(NewGradleSync.class);
        if (logger == null) {
            NewGradleSync.$$$reportNull$$$0(17);
        }
        return logger;
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        Throwable rootCause;
        String message;
        if (error == null) {
            NewGradleSync.$$$reportNull$$$0(18);
        }
        return StringUtil.isEmpty((String)(message = (rootCause = ExceptionUtil.getRootCause((Throwable)error)).getMessage())) ? rootCause.getClass().getName() : message;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        String string = StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
        if (string == null) {
            NewGradleSync.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            NewGradleSync.$$$reportNull$$$0(20);
        }
        NewGradleSync.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetupFactory";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/NewGradleSync";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/NewGradleSync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sync";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "nullToUnknownErrorCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFinished";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyAndLogSyncError";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFailed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "logSyncFailure";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sync$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sync$1";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sync$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class Callback
    extends ActionCallback {
        @Nullable
        private SyncAction.ProjectModels myModels;
        @Nullable
        private Throwable mySyncError;

        Callback() {
        }

        @Nullable
        SyncAction.ProjectModels getModels() {
            return this.myModels;
        }

        void setDone(@Nullable SyncAction.ProjectModels models) {
            this.myModels = models;
            this.setDone();
        }

        @Nullable
        Throwable getSyncError() {
            return this.mySyncError;
        }

        void setRejected(@NotNull Throwable error) {
            if (error == null) {
                Callback.$$$reportNull$$$0(0);
            }
            this.mySyncError = error;
            this.setRejected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/NewGradleSync$Callback", "setRejected"));
        }
    }
}

