/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.subset;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.subset.ModulesToImportDialog;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSubset {
    @NonNls
    private static final String PROJECT_SUBSET_PROPERTY_NAME = "com.android.studio.selected.modules.on.import";
    private static final String MODULE_LOOKUP_MESSAGE_TITLE = "Module Lookup";
    @NotNull
    private final Project myProject;

    @NotNull
    public static ProjectSubset getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectSubset.$$$reportNull$$$0(0);
        }
        ProjectSubset projectSubset = (ProjectSubset)ServiceManager.getService((Project)project, ProjectSubset.class);
        if (projectSubset == null) {
            ProjectSubset.$$$reportNull$$$0(1);
        }
        return projectSubset;
    }

    public ProjectSubset(@NotNull Project project) {
        if (project == null) {
            ProjectSubset.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public boolean isFeatureEnabled() {
        return GradleExperimentalSettings.getInstance().SELECT_MODULES_ON_PROJECT_IMPORT;
    }

    public boolean hasCachedModules() {
        DataNode<ProjectData> projectInfo = DataNodeCaches.getInstance(this.myProject).getCachedProjectData();
        if (projectInfo != null) {
            return !ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE).isEmpty();
        }
        return false;
    }

    public void addOrRemoveModules() {
        Collection<DataNode<ModuleData>> selectedModules;
        DataNode<ProjectData> projectInfo = DataNodeCaches.getInstance(this.myProject).getCachedProjectData();
        if (projectInfo == null) {
            return;
        }
        Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        HashSet selectedModuleNames = Collections.emptySet();
        Object[] selection = this.getSelection();
        if (selection != null) {
            selectedModuleNames = Sets.newHashSet((Object[])selection);
        }
        if ((selectedModules = this.showModuleSelectionDialog(moduleInfos, selectedModuleNames)) != null) {
            this.setSelection(selectedModules);
            if (!Arrays.equals(this.getSelection(), selection)) {
                Projects.populate(this.myProject, projectInfo, selectedModules, PostSyncProjectSetup.Request.DEFAULT_REQUEST);
            }
        }
    }

    public void findAndIncludeModuleContainingSourceFile(@NotNull VirtualFile virtualFile) {
        DataNode<ProjectData> projectInfo;
        if (virtualFile == null) {
            ProjectSubset.$$$reportNull$$$0(3);
        }
        if ((projectInfo = DataNodeCaches.getInstance(this.myProject).getCachedProjectData()) == null) {
            return;
        }
        final Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (!moduleInfos.isEmpty()) {
            final File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            new Task.Modal(this.myProject, "Looking up Module", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ArrayList results = Lists.newArrayList();
                    Object[] storedSelection = ProjectSubset.this.getSelection();
                    HashSet selection = storedSelection != null ? Sets.newHashSet((Object[])storedSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    int doneCount = 0;
                    for (DataNode moduleNode : moduleInfos) {
                        ModuleSearchResult result;
                        indicator.setFraction((double)(++doneCount / moduleInfos.size()));
                        ModuleData module = (ModuleData)moduleNode.getData();
                        String name = module.getExternalName();
                        boolean selected = selection.contains(name);
                        if (selected) {
                            selectedModules.add(moduleNode);
                        }
                        if ((result = ProjectSubset.containsSourceFile((DataNode<ModuleData>)moduleNode, file, selected)) == null) continue;
                        results.add(result);
                    }
                    int resultCount = results.size();
                    if (resultCount == 0) {
                        UIUtil.invokeLaterIfNeeded(() -> {
                            String text = String.format("Unable to find a module containing the file '%1$s' in a source directory.", file.getName());
                            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(ProjectSubset.this.myProject);
                            notification.showBalloon(ProjectSubset.MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.ERROR);
                        });
                    } else if (resultCount == 1) {
                        ProjectSubset.this.addResultAndPopulateProject((ModuleSearchResult)results.get(0), (DataNode<ProjectData>)projectInfo, selectedModules, file);
                    } else {
                        ProjectSubset.this.showModuleSelectionDialog(results, (DataNode<ProjectData>)projectInfo, selectedModules, file);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/subset/ProjectSubset$1", "run"));
                }
            }.queue();
        }
    }

    @Nullable
    private static ModuleSearchResult containsSourceFile(@NotNull DataNode<ModuleData> moduleInfos, @NotNull File file, boolean selected) {
        JavaModuleModel javaModuleModel;
        AndroidModuleModel androidModel;
        AndroidModuleModel.SourceFileContainerInfo result;
        DataNode androidProjectNode;
        if (moduleInfos == null) {
            ProjectSubset.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ProjectSubset.$$$reportNull$$$0(5);
        }
        if ((androidProjectNode = ExternalSystemApiUtil.find(moduleInfos, AndroidProjectKeys.ANDROID_MODEL)) != null && (result = (androidModel = (AndroidModuleModel)androidProjectNode.getData()).containsSourceFile(file)) != null) {
            return new ModuleSearchResult(moduleInfos, result, selected);
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find(moduleInfos, AndroidProjectKeys.JAVA_MODULE_MODEL);
        if (javaProjectNode != null && (javaModuleModel = (JavaModuleModel)javaProjectNode.getData()).containsSourceFile(file)) {
            return new ModuleSearchResult(moduleInfos, null, selected);
        }
        return null;
    }

    private void addResultAndPopulateProject(@NotNull ModuleSearchResult result, @NotNull DataNode<ProjectData> projectInfo, @NotNull List<DataNode<ModuleData>> selectedModules, @NotNull File file) {
        String text;
        if (result == null) {
            ProjectSubset.$$$reportNull$$$0(6);
        }
        if (projectInfo == null) {
            ProjectSubset.$$$reportNull$$$0(7);
        }
        if (selectedModules == null) {
            ProjectSubset.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ProjectSubset.$$$reportNull$$$0(9);
        }
        DataNode<ModuleData> moduleNode = result.moduleNode;
        String moduleName = ProjectSubset.getNameOf(moduleNode);
        if (result.selected) {
            String tmp = String.format("File '%1$s' is already in module '%2$s'", file.getName(), moduleName);
            AndroidModuleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
                Variant variant = containerInfo.variant;
                if (variant != null) {
                    tmp = tmp + String.format(", variant '%1$s'", variant.getName());
                }
            }
            text = tmp;
        } else {
            text = String.format("Module '%1$s' was added to the project.", moduleName);
            AndroidModuleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
            }
            selectedModules.add(moduleNode);
            this.setSelection(selectedModules);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
            notification.showBalloon(MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.INFORMATION);
        });
        Projects.populate(this.myProject, projectInfo, selectedModules, PostSyncProjectSetup.Request.DEFAULT_REQUEST);
    }

    private void showModuleSelectionDialog(@NotNull List<ModuleSearchResult> searchResults, @NotNull DataNode<ProjectData> projectInfo, @NotNull List<DataNode<ModuleData>> selection, @NotNull File file) {
        if (searchResults == null) {
            ProjectSubset.$$$reportNull$$$0(10);
        }
        if (projectInfo == null) {
            ProjectSubset.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            ProjectSubset.$$$reportNull$$$0(12);
        }
        if (file == null) {
            ProjectSubset.$$$reportNull$$$0(13);
        }
        ArrayList finalSelection = Lists.newArrayList(selection);
        ArrayList modulesToDisplayInDialog = Lists.newArrayList();
        HashMap resultsByModuleName = Maps.newHashMap();
        for (ModuleSearchResult result : searchResults) {
            DataNode<ModuleData> module = result.moduleNode;
            modulesToDisplayInDialog.add(module);
            if (result.selected) {
                finalSelection.remove(module);
            }
            String moduleName = ProjectSubset.getNameOf(module);
            resultsByModuleName.put(moduleName, result);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            Collection<DataNode<ModuleData>> selectedModules;
            if (file == null) {
                ProjectSubset.$$$reportNull$$$0(21);
            }
            if (projectInfo == null) {
                ProjectSubset.$$$reportNull$$$0(22);
            }
            ModulesToImportDialog dialog = new ModulesToImportDialog(modulesToDisplayInDialog, this.myProject);
            String description = String.format("The file '%1$s' may be include in one of the following modules.", file.getName());
            dialog.setDescription(description);
            dialog.clearSelection();
            if (dialog.showAndGet() && !(selectedModules = dialog.getSelectedModules()).isEmpty()) {
                for (DataNode<ModuleData> selectedModule : selectedModules) {
                    AndroidModuleModel.SourceFileContainerInfo containerInfo;
                    String name = ProjectSubset.getNameOf(selectedModule);
                    ModuleSearchResult result = (ModuleSearchResult)resultsByModuleName.get(name);
                    if (result == null || (containerInfo = result.containerInfo) == null) continue;
                    containerInfo.updateSelectedVariantIn(selectedModule);
                }
                finalSelection.addAll(selectedModules);
                this.setSelection(finalSelection);
                Projects.populate(this.myProject, projectInfo, finalSelection, PostSyncProjectSetup.Request.DEFAULT_REQUEST);
            }
        });
    }

    public void findAndIncludeModules(final @NotNull Collection<String> moduleGradlePaths) {
        DataNode<ProjectData> projectInfo;
        if (moduleGradlePaths == null) {
            ProjectSubset.$$$reportNull$$$0(14);
        }
        if ((projectInfo = DataNodeCaches.getInstance(this.myProject).getCachedProjectData()) == null) {
            return;
        }
        final Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (!moduleInfos.isEmpty()) {
            final Project project = this.myProject;
            new Task.Modal(project, "Finding Missing Modules", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    Object[] originalSelection;
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    HashSet selection = (originalSelection = ProjectSubset.this.getSelection()) != null ? Sets.newHashSet((Object[])originalSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    boolean found = false;
                    int doneCount = 0;
                    for (DataNode moduleInfo : moduleInfos) {
                        GradleModuleModel gradleModuleModel;
                        indicator.setFraction((double)(++doneCount / moduleInfos.size()));
                        String name = ProjectSubset.getNameOf((DataNode<ModuleData>)moduleInfo);
                        if (selection.contains(name)) {
                            selectedModules.add(moduleInfo);
                            continue;
                        }
                        DataNode gradleProjectNode = ExternalSystemApiUtil.find((DataNode)moduleInfo, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                        if (gradleProjectNode == null || !moduleGradlePaths.contains((gradleModuleModel = (GradleModuleModel)gradleProjectNode.getData()).getGradlePath())) continue;
                        selection.add(name);
                        selectedModules.add(moduleInfo);
                        found = true;
                    }
                    if (!selectedModules.isEmpty() && found) {
                        ProjectSubset.this.setSelection(selectedModules);
                        Projects.populate(project, (DataNode<ProjectData>)projectInfo, selectedModules, PostSyncProjectSetup.Request.DEFAULT_REQUEST);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/subset/ProjectSubset$2", "run"));
                }
            }.queue();
        }
    }

    @Nullable
    public Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules) {
        if (modules == null) {
            ProjectSubset.$$$reportNull$$$0(15);
        }
        Set<String> noSelection = Collections.emptySet();
        return this.showModuleSelectionDialog(modules, noSelection);
    }

    @Nullable
    private Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull Collection<String> selectedModuleNames) {
        if (modules == null) {
            ProjectSubset.$$$reportNull$$$0(16);
        }
        if (selectedModuleNames == null) {
            ProjectSubset.$$$reportNull$$$0(17);
        }
        ModulesToImportDialog dialog = new ModulesToImportDialog(modules, this.myProject);
        if (!selectedModuleNames.isEmpty()) {
            dialog.updateSelection(selectedModuleNames);
        }
        if (dialog.showAndGet()) {
            Collection<DataNode<ModuleData>> selectedModules = dialog.getSelectedModules();
            this.setSelection(selectedModules);
            return selectedModules;
        }
        return null;
    }

    private void setSelection(@NotNull Collection<DataNode<ModuleData>> modules) {
        if (modules == null) {
            ProjectSubset.$$$reportNull$$$0(18);
        }
        ArrayList moduleNames = Lists.newArrayListWithExpectedSize((int)modules.size());
        for (DataNode<ModuleData> module : modules) {
            moduleNames.add(ProjectSubset.getNameOf(module));
        }
        this.updateSelection(moduleNames);
    }

    @NotNull
    private static String getNameOf(@NotNull DataNode<ModuleData> module) {
        if (module == null) {
            ProjectSubset.$$$reportNull$$$0(19);
        }
        String string = ((ModuleData)module.getData()).getExternalName();
        if (string == null) {
            ProjectSubset.$$$reportNull$$$0(20);
        }
        return string;
    }

    public void clearSelection() {
        this.updateSelection(null);
    }

    private void updateSelection(@Nullable List<String> moduleNames) {
        String[] values = moduleNames != null ? ArrayUtil.toStringArray(moduleNames) : null;
        PropertiesComponent.getInstance((Project)this.myProject).setValues(PROJECT_SUBSET_PROPERTY_NAME, values);
    }

    @Nullable
    public String[] getSelection() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValues(PROJECT_SUBSET_PROPERTY_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/subset/ProjectSubset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleInfos";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGradlePaths";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedModuleNames";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/subset/ProjectSubset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAndIncludeModuleContainingSourceFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsSourceFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addResultAndPopulateProject";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showModuleSelectionDialog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAndIncludeModules";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNameOf";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showModuleSelectionDialog$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleSearchResult {
        @NotNull
        public final DataNode<ModuleData> moduleNode;
        @Nullable
        public final AndroidModuleModel.SourceFileContainerInfo containerInfo;
        public final boolean selected;

        ModuleSearchResult(@NotNull DataNode<ModuleData> moduleNode, @Nullable AndroidModuleModel.SourceFileContainerInfo containerInfo, boolean selected) {
            if (moduleNode == null) {
                ModuleSearchResult.$$$reportNull$$$0(0);
            }
            this.moduleNode = moduleNode;
            this.containerInfo = containerInfo;
            this.selected = selected;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/project/subset/ProjectSubset$ModuleSearchResult", "<init>"));
        }
    }
}

