/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        GradleInitScripts gradleInitScripts = (GradleInitScripts)ServiceManager.getService(GradleInitScripts.class);
        if (gradleInitScripts == null) {
            GradleInitScripts.$$$reportNull$$$0(0);
        }
        return gradleInitScripts;
    }

    public GradleInitScripts() {
        this(new ContentCreator());
    }

    @VisibleForTesting
    GradleInitScripts(@NotNull ContentCreator contentCreator) {
        if (contentCreator == null) {
            GradleInitScripts.$$$reportNull$$$0(1);
        }
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArgTo(@NotNull List<String> allArgs) {
        File initScriptFile;
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(2);
        }
        if ((initScriptFile = this.createLocalMavenRepoInitScriptFile()) != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @VisibleForTesting
    @Nullable
    File createLocalMavenRepoInitScriptFile() {
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        String content = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths);
        if (content != null) {
            return GradleInitScripts.createInitScriptFile("asLocalRepo", content);
        }
        return null;
    }

    public void addProfilerClasspathInitScriptCommandLineArgTo(@NotNull List<String> allArgs) {
        String content;
        File initScriptFile;
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(3);
        }
        if ((initScriptFile = GradleInitScripts.createInitScriptFile("asPerfClasspath", content = "allprojects {\n  buildscript {\n    dependencies {\n      classpath 'com.android.tools:studio-profiler-plugin:1.0'\n    }\n  }\n}\n")) != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content) {
        if (fileName == null) {
            GradleInitScripts.$$$reportNull$$$0(4);
        }
        if (content == null) {
            GradleInitScripts.$$$reportNull$$$0(5);
        }
        try {
            File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
            file.deleteOnExit();
            FileUtil.writeToFile((File)file, (String)content);
            return file;
        }
        catch (Throwable e) {
            String message = String.format("Failed to set up  Gradle init script: '%1$s'", fileName);
            Logger.getInstance(GradleInitScripts.class).warn(message, e);
            return null;
        }
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        if (initScriptFile == null) {
            GradleInitScripts.$$$reportNull$$$0(6);
        }
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(7);
        }
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentCreator";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLocalMavenRepoInitScriptCommandLineArgTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProfilerClasspathInitScriptCommandLineArgTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInitScriptFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInitScriptCommandLineArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class ContentCreator {
        ContentCreator() {
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<File> repoPaths) {
            if (repoPaths == null) {
                ContentCreator.$$$reportNull$$$0(0);
            }
            if (repoPaths.isEmpty()) {
                return null;
            }
            String paths = "";
            for (File file : repoPaths) {
                String path = GradleImport.escapeGroovyStringLiteral(file.getPath());
                paths = paths + "      maven { url '" + path + "'}\n";
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPaths", "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator", "createLocalMavenRepoInitScriptContent"));
        }
    }
}

