/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GradleProjectBuilder {
    @NotNull
    private final Project myProject;

    @NotNull
    public static GradleProjectBuilder getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectBuilder.$$$reportNull$$$0(0);
        }
        GradleProjectBuilder gradleProjectBuilder = (GradleProjectBuilder)ServiceManager.getService((Project)project, GradleProjectBuilder.class);
        if (gradleProjectBuilder == null) {
            GradleProjectBuilder.$$$reportNull$$$0(1);
        }
        return gradleProjectBuilder;
    }

    public GradleProjectBuilder(@NotNull Project project) {
        if (project == null) {
            GradleProjectBuilder.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void assembleTranslate() {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleBuildInvoker.getInstance(this.myProject).assembleTranslate();
                return;
            }
            this.buildProjectWithJps(BuildMode.ASSEMBLE_TRANSLATE);
        }
    }

    public void compileJava() {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                GradleBuildInvoker.getInstance(this.myProject).compileJava(modules, GradleBuildInvoker.TestCompileType.NONE);
                return;
            }
            this.buildProjectWithJps(BuildMode.COMPILE_JAVA);
        }
    }

    public void clean() {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleBuildInvoker.getInstance(this.myProject).cleanProject();
                return;
            }
            this.buildProjectWithJps(BuildMode.CLEAN);
        }
    }

    public void generateSourcesOnly(boolean cleanProject) {
        if (!this.isSourceGenerationEnabled()) {
            return;
        }
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleBuildInvoker.getInstance(this.myProject).generateSources(cleanProject);
            } else {
                this.buildProjectWithJps(BuildMode.SOURCE_GEN);
            }
        }
    }

    public boolean isSourceGenerationEnabled() {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            int moduleCount = ModuleManager.getInstance((Project)this.myProject).getModules().length;
            GradleExperimentalSettings settings = GradleExperimentalSettings.getInstance();
            return GradleProjectBuilder.isSourceGenerationEnabled(settings, moduleCount);
        }
        return false;
    }

    @VisibleForTesting
    @Contract(pure=true)
    static boolean isSourceGenerationEnabled(@NotNull GradleExperimentalSettings settings, int moduleCount) {
        if (settings == null) {
            GradleProjectBuilder.$$$reportNull$$$0(3);
        }
        return !settings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC || moduleCount <= settings.MAX_MODULE_COUNT_FOR_SOURCE_GEN;
    }

    private void buildProjectWithJps(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleProjectBuilder.$$$reportNull$$$0(4);
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
        CompilerManager.getInstance((Project)this.myProject).make(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/GradleProjectBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/GradleProjectBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSourceGenerationEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildProjectWithJps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

