/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public class AndroidGradleProjectComponent
extends AbstractProjectComponent {
    @NonNls
    private static final String SHOW_MIGRATE_TO_GRADLE_POPUP = "show.migrate.to.gradle.popup";
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(0);
        }
        AndroidGradleProjectComponent component = (AndroidGradleProjectComponent)((Object)project.getComponent(AndroidGradleProjectComponent.class));
        assert (component != null);
        AndroidGradleProjectComponent androidGradleProjectComponent = component;
        if (androidGradleProjectComponent == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(1);
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(2);
        }
        super(project);
        CompilerManager.getInstance((Project)this.myProject).addAfterTask(context -> {
            if (project == null) {
                AndroidGradleProjectComponent.$$$reportNull$$$0(6);
            }
            if (Projects.isBuildWithGradle(this.myProject)) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            }
            return true;
        });
        GradleBuildInvoker.getInstance(this.myProject).add(result -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PostProjectBuildTasksExecutor.getInstance(this.myProject).onBuildCompletion(result);
            GradleBuildContext newContext = new GradleBuildContext(result);
            AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            ApplicationManager.getApplication().invokeLater(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                SaveAndSyncHandler.getInstance().refreshOpenFiles();
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
            });
        });
    }

    public void projectOpened() {
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            syncState.notifyStateChanged();
        }
        if (Projects.isLegacyIdeaAndroidProject(this.myProject) && !ApkProjects.isApkProject(this.myProject)) {
            this.trackLegacyIdeaAndroidProject();
            if (this.shouldShowMigrateToGradleNotification()) {
                this.showMigrateToGradleWarning();
            }
            return;
        }
        boolean isGradleProject = Projects.isBuildWithGradle(this.myProject);
        if (isGradleProject) {
            this.configureGradleProject();
        } else if (IdeInfo.getInstance().isAndroidStudio() && this.myProject.getBaseDir() != null && Projects.canImportAsGradleProject(this.myProject.getBaseDir())) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, null);
        }
    }

    private boolean shouldShowMigrateToGradleNotification() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_MIGRATE_TO_GRADLE_POPUP, true);
    }

    private void trackLegacyIdeaAndroidProject() {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            String packageName = null;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet != null && !facet.requiresAndroidModel()) {
                    String modulePackageName;
                    if (facet.isAppProject()) {
                        packageName = AndroidGradleProjectComponent.getPackageNameInLegacyIdeaAndroidModule(facet);
                        if (packageName != null) {
                            break;
                        }
                    } else if (packageName == null && (modulePackageName = AndroidGradleProjectComponent.getPackageNameInLegacyIdeaAndroidModule(facet)) != null) {
                        packageName = modulePackageName;
                    }
                }
                if (packageName == null) continue;
                AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.LEGACY_IDEA_ANDROID_PROJECT).setProjectId(AndroidStudioUsageTracker.anonymizeUtf8(packageName));
                UsageTracker.getInstance().log(event);
            }
        });
    }

    @Nullable
    private static String getPackageNameInLegacyIdeaAndroidModule(@NotNull AndroidFacet facet) {
        Manifest manifest;
        if (facet == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(3);
        }
        return (manifest = facet.getManifest()) != null ? (String)manifest.getPackage().getValue() : null;
    }

    private void showMigrateToGradleWarning() {
        String errMsg = "This project does not use the Gradle build system. We recommend that you migrate to using the Gradle build system.";
        NotificationHyperlink moreInfoHyperlink = new OpenMigrationToGradleUrlHyperlink().setCloseOnClick(true);
        NotificationHyperlink doNotShowAgainHyperlink = new NotificationHyperlink("do.not.show", "Don't show this message again."){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                PropertiesComponent.getInstance((Project)AndroidGradleProjectComponent.this.myProject).setValue(AndroidGradleProjectComponent.SHOW_MIGRATE_TO_GRADLE_POPUP, Boolean.FALSE.toString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$1", "execute"));
            }
        };
        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
        notification.showBalloon("Migrate Project to Gradle?", errMsg, NotificationType.WARNING, moreInfoHyperlink, doNotShowAgainHyperlink);
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = () -> {};
        this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        ArrayList runConfigurationProducerTypes = new ArrayList();
        runConfigurationProducerTypes.add(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestClassGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestMethodGradleConfigurationProducer.class);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.ignore(runConfigurationProducerTypes);
        } else {
            this.doNotIgnore(runConfigurationProducerTypes);
        }
    }

    private void ignore(@NotNull List<Class<? extends RunConfigurationProducer<?>>> runConfigurationProducerTypes) {
        if (runConfigurationProducerTypes == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(4);
        }
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        for (Class<RunConfigurationProducer<?>> type : runConfigurationProducerTypes) {
            runConfigurationProducerManager.getState().ignoredProducers.add(type.getName());
        }
    }

    private void doNotIgnore(@NotNull List<Class<? extends RunConfigurationProducer<?>>> runConfigurationProducerTypes) {
        if (runConfigurationProducerTypes == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(5);
        }
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        for (Class<RunConfigurationProducer<?>> type : runConfigurationProducerTypes) {
            runConfigurationProducerManager.getState().ignoredProducers.remove(type.getName());
        }
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationProducerTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameInLegacyIdeaAndroidModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ignore";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doNotIgnore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

