/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleEditorSourceBinding> myDefinitionValueSourceBindings;
    @NotNull
    private final GradleEditorEntityValueManager myValueManager;
    @NotNull
    private final GradleEditorSourceBinding myDeclarationValueLocation;
    @NotNull
    private String myCurrentValue;

    public AbstractSimpleGradleEditorEntity(@NotNull String name, @NotNull String currentValue, @NotNull Collection<GradleEditorSourceBinding> definitionValueSourceBindings, @NotNull GradleEditorSourceBinding entityLocation, @NotNull Set<GradleEditorEntityMetaData> metaData, @NotNull GradleEditorSourceBinding declarationValueLocation, @NotNull GradleEditorEntityValueManager valueManager, @Nullable String helpUrl) {
        if (name == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(0);
        }
        if (currentValue == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(1);
        }
        if (definitionValueSourceBindings == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(2);
        }
        if (entityLocation == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(3);
        }
        if (metaData == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(4);
        }
        if (declarationValueLocation == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(5);
        }
        if (valueManager == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(6);
        }
        super(entityLocation, metaData, helpUrl);
        this.myName = name;
        this.myCurrentValue = currentValue;
        this.myDefinitionValueSourceBindings = ImmutableList.copyOf(definitionValueSourceBindings);
        this.myDeclarationValueLocation = declarationValueLocation;
        this.myValueManager = valueManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getCurrentValue() {
        String string = this.myCurrentValue;
        if (string == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        GradleEditorSourceBinding gradleEditorSourceBinding = this.myDeclarationValueLocation;
        if (gradleEditorSourceBinding == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(9);
        }
        return gradleEditorSourceBinding;
    }

    @Override
    @Nullable
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myDefinitionValueSourceBindings.size() == 1 ? this.myDefinitionValueSourceBindings.get(0) : null;
    }

    @Nullable
    public String changeValue(@NotNull String newValue) {
        if (newValue == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(10);
        }
        if (newValue.equals(this.getCurrentValue())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getDefinitionValueSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one source binding but it has %d (%s)", newValue, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newValue, this);
        }
        this.myCurrentValue = newValue;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newValue);
        return null;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getDefinitionValueSourceBindings() {
        List<GradleEditorSourceBinding> list = this.myDefinitionValueSourceBindings;
        if (list == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public GradleEditorEntityValueManager getValueManager() {
        GradleEditorEntityValueManager gradleEditorEntityValueManager = this.myValueManager;
        if (gradleEditorEntityValueManager == null) {
            AbstractSimpleGradleEditorEntity.$$$reportNull$$$0(12);
        }
        return gradleEditorEntityValueManager;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDeclarationValueLocation);
        for (GradleEditorSourceBinding sourceBinding : this.myDefinitionValueSourceBindings) {
            Disposer.dispose((Disposable)sourceBinding);
        }
    }

    public String toString() {
        String value;
        List<GradleEditorSourceBinding> bindings = this.getDefinitionValueSourceBindings();
        if (bindings.isEmpty()) {
            value = "<undefined>";
        } else if (bindings.size() > 1) {
            value = "<ref>";
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(bindings.get(0).getFile());
            RangeMarker rangeMarker = bindings.get(0).getRangeMarker();
            value = document == null ? "<unexpected!>" : '[' + document.getCharsSequence().subSequence(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()).toString() + ']';
        }
        return this.getName() + " " + value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionValueSourceBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityLocation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationValueLocation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationValueLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionValueSourceBindings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

