/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.editor.GradleEditorNotificationListener;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParserFacade;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComponent;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final GradleEditorComponent myComponent;
    @Nullable
    private Document myDocument;
    @Nullable
    private DocumentListener myDocumentListener;
    @Nullable
    private MessageBusConnection myConnection;
    @Nullable
    private List<GradleEditorEntityGroup> myGroups;
    private volatile boolean myEditorTriggeredModificationInProgress;

    public GradleFileEditor(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            GradleFileEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleFileEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myGroups = new GradleEditorModelParserFacade().parse(virtualFile, project);
        this.myComponent = new GradleEditorComponent(project, this.myGroups);
        this.myDocument = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (this.myDocument == null) {
            this.myDocumentListener = null;
            this.myConnection = null;
        } else {
            this.myDocumentListener = new DocumentListener(){

                public void documentChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
                        return;
                    }
                    if (!GradleFileEditor.this.myEditorTriggeredModificationInProgress) {
                        GradleFileEditor.this.refresh();
                    }
                }
            };
            this.myDocument.addDocumentListener(this.myDocumentListener);
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

                public void updateFinished(@NotNull Document doc) {
                    if (doc == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!GradleFileEditor.this.myEditorTriggeredModificationInProgress) {
                        GradleFileEditor.this.refresh();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/android/tools/idea/gradle/editor/GradleFileEditor$2", "updateFinished"));
                }
            });
            this.myConnection.subscribe(GradleEditorNotificationListener.TOPIC, (Object)new GradleEditorNotificationListener(){

                @Override
                public void beforeChange() {
                    GradleFileEditor.this.myEditorTriggeredModificationInProgress = true;
                }

                @Override
                public void afterChange() {
                    GradleFileEditor.this.myEditorTriggeredModificationInProgress = false;
                }
            });
        }
    }

    @NotNull
    public JComponent getComponent() {
        GradleEditorComponent gradleEditorComponent = this.myComponent;
        if (gradleEditorComponent == null) {
            GradleFileEditor.$$$reportNull$$$0(2);
        }
        return gradleEditorComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.gradle.editor.tab.name", new Object[0]);
        if (string == null) {
            GradleFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            GradleFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.refresh();
    }

    public void deselectNotify() {
        this.myComponent.flushChanges();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            GradleFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            GradleFileEditor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myDocument != null && this.myDocumentListener != null) {
            this.myDocument.removeDocumentListener(this.myDocumentListener);
            this.myDocument = null;
            this.myDocumentListener = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
        this.disposeGroups();
    }

    public void refresh() {
        if (this.myDocument != null) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            psiDocumentManager.commitDocument(this.myDocument);
        }
        this.disposeGroups();
        this.myGroups = new GradleEditorModelParserFacade().parse(this.myVirtualFile, this.myProject);
        this.myComponent.setData(this.myGroups);
    }

    private void disposeGroups() {
        List<GradleEditorEntityGroup> groups = this.myGroups;
        if (groups != null) {
            for (GradleEditorEntityGroup group : groups) {
                Disposer.dispose((Disposable)group);
            }
            this.myGroups = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/GradleFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/GradleFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

