/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyModel.class);
    @NonNls
    private static final String PROJECT = "project";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private GradleDslMethodCall myDslElement;
    @NotNull
    private GradleDslExpression myPath;
    @Nullable
    private GradleDslExpression myConfiguration;

    @NotNull
    static List<ModuleDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        if (configurationName == null) {
            ModuleDependencyModel.$$$reportNull$$$0(0);
        }
        if (methodCall == null) {
            ModuleDependencyModel.$$$reportNull$$$0(1);
        }
        ArrayList result = Lists.newArrayList();
        if (PROJECT.equals(methodCall.getName())) {
            for (GradleDslElement argument : methodCall.getArguments()) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new ModuleDependencyModel(configurationName, methodCall, (GradleDslExpression)argument, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression pathElement = dslMap.getPropertyElement(PATH, GradleDslExpression.class);
                if (pathElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid module dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslExpression configuration = dslMap.getPropertyElement(CONFIGURATION, GradleDslExpression.class);
                result.add(new ModuleDependencyModel(configurationName, methodCall, pathElement, configuration));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ModuleDependencyModel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (list == null) {
            ModuleDependencyModel.$$$reportNull$$$0(3);
        }
        if (configurationName == null) {
            ModuleDependencyModel.$$$reportNull$$$0(4);
        }
        if (path == null) {
            ModuleDependencyModel.$$$reportNull$$$0(5);
        }
        String methodName = PROJECT;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, methodName);
        mapArguments.setNewLiteral(PATH, path);
        if (config != null) {
            mapArguments.setNewLiteral(CONFIGURATION, config);
        }
        methodCall.addNewArgument(mapArguments);
        list.addNewElement(methodCall);
    }

    private ModuleDependencyModel(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression path, @Nullable GradleDslExpression configuration) {
        if (configurationName == null) {
            ModuleDependencyModel.$$$reportNull$$$0(6);
        }
        if (dslElement == null) {
            ModuleDependencyModel.$$$reportNull$$$0(7);
        }
        if (path == null) {
            ModuleDependencyModel.$$$reportNull$$$0(8);
        }
        this.myConfigurationName = configurationName;
        this.myDslElement = dslElement;
        this.myPath = path;
        this.myConfiguration = configuration;
    }

    @Override
    @NotNull
    protected GradleDslMethodCall getDslElement() {
        GradleDslMethodCall gradleDslMethodCall = this.myDslElement;
        if (gradleDslMethodCall == null) {
            ModuleDependencyModel.$$$reportNull$$$0(9);
        }
        return gradleDslMethodCall;
    }

    @Override
    @NotNull
    public String configurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            ModuleDependencyModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String name() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.path().value());
        int segmentCount = pathSegments.size();
        String string = segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
        if (string == null) {
            ModuleDependencyModel.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        String newPath;
        List segments;
        ArrayList modifiableSegments;
        int segmentCount;
        if (name == null) {
            ModuleDependencyModel.$$$reportNull$$$0(12);
        }
        if ((segmentCount = (modifiableSegments = Lists.newArrayList((Iterable)(segments = Splitter.on((String)":").splitToList((CharSequence)this.path().value())))).size()) == 0) {
            newPath = ":" + name.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, name);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        this.setPath(newPath);
    }

    @NotNull
    public GradleNotNullValue<String> path() {
        String path = this.myPath.getValue(String.class);
        assert (path != null);
        GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myPath, path);
        if (gradleNotNullValue == null) {
            ModuleDependencyModel.$$$reportNull$$$0(13);
        }
        return gradleNotNullValue;
    }

    public void setPath(@NotNull String path) {
        if (path == null) {
            ModuleDependencyModel.$$$reportNull$$$0(14);
        }
        this.myPath.setValue(path);
    }

    @NotNull
    public GradleNullableValue<String> configuration() {
        if (this.myConfiguration == null) {
            GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(this.myDslElement, null);
            if (gradleNullableValue == null) {
                ModuleDependencyModel.$$$reportNull$$$0(15);
            }
            return gradleNullableValue;
        }
        GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myConfiguration, this.myConfiguration.getValue(String.class));
        if (gradleNullableValue == null) {
            ModuleDependencyModel.$$$reportNull$$$0(16);
        }
        return gradleNullableValue;
    }

    void setConfiguration(@NotNull String configuration) {
        if (configuration == null) {
            ModuleDependencyModel.$$$reportNull$$$0(17);
        }
        if (this.myConfiguration != null) {
            this.myConfiguration.setValue(configuration);
            return;
        }
        GradleDslElement parent = this.myPath.getParent();
        if (parent instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).setNewLiteral(CONFIGURATION, configuration);
        } else {
            String path = this.path().value();
            if (this.myPath instanceof GradleDslLiteral) {
                GradleDslExpressionMap newMapArgument = new GradleDslExpressionMap(this.myDslElement, PROJECT);
                newMapArgument.setNewLiteral(PATH, path);
                newMapArgument.setNewLiteral(CONFIGURATION, configuration);
                this.myDslElement.remove(this.myPath);
                this.myDslElement.addNewArgument(newMapArgument);
            }
        }
    }

    void removeConfiguration() {
        GradleDslElement parent;
        if (this.myConfiguration != null && (parent = this.myConfiguration.getParent()) instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).removeProperty(CONFIGURATION);
            this.myConfiguration = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONFIGURATION;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configurationName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = PATH;
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = CONFIGURATION;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddToList";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

