/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.LinkExternalCppProjectDialog;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkExternalCppProjectAction
extends AndroidStudioGradleAction {
    public LinkExternalCppProjectAction() {
        super("Link C++ Project with Gradle", "Link an external C/C++ project (cmake or ndk-build) with Gradle", null);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        boolean enable = LinkExternalCppProjectAction.isValidAndroidGradleModuleSelected(dataContext);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enable);
        presentation.setVisible(enable);
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        Module module = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        assert (module != null);
        new LinkExternalCppProjectDialog(module).show();
    }

    private static boolean isValidAndroidGradleModuleSelected(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(4);
        }
        if ((module = LinkExternalCppProjectAction.getSelectedModule(dataContext)) == null) {
            return false;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null || !androidModel.getFeatures().isExternalBuildSupported()) {
            return false;
        }
        AndroidPluginGeneration pluginGeneration = AndroidPluginGeneration.find(module);
        if (pluginGeneration == AndroidPluginGeneration.COMPONENT) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        if (ndkModuleModel != null) {
            return false;
        }
        return GradleBuildModel.get(module) != null;
    }

    @Nullable
    private static Module getSelectedModule(@NotNull DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            LinkExternalCppProjectAction.$$$reportNull$$$0(5);
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null && modules.length == 1) {
            return modules[0];
        }
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidAndroidGradleModuleSelected";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

