/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToApkLocationTask
implements GradleBuildInvoker.AfterGradleInvocationTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNotificationTitle;
    @NotNull
    private final List<File> myPotentialApkLocations;

    public GoToApkLocationTask(@NotNull String notificationTitle, @NotNull Module module, @Nullable String apkPath) {
        AndroidModuleModel androidModel;
        if (notificationTitle == null) {
            GoToApkLocationTask.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GoToApkLocationTask.$$$reportNull$$$0(1);
        }
        this.myProject = module.getProject();
        this.myNotificationTitle = notificationTitle;
        this.myPotentialApkLocations = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)apkPath)) {
            this.myPotentialApkLocations.add(new File(apkPath));
        }
        if (Projects.isBuildWithGradle(this.myProject) && (androidModel = AndroidModuleModel.get(module)) != null) {
            File buildDirPath = androidModel.getAndroidProject().getBuildFolder();
            this.myPotentialApkLocations.add(new File(buildDirPath, FileUtil.join((String[])new String[]{"outputs", "apk"})));
            this.myPotentialApkLocations.add(buildDirPath);
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        this.myPotentialApkLocations.add(moduleFilePath.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull GradleInvocationResult result) {
        if (result == null) {
            GoToApkLocationTask.$$$reportNull$$$0(2);
        }
        try {
            File apkPath = this.getExistingApkPath();
            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
            if (result.isBuildSuccessful()) {
                if (ShowFilePathAction.isSupported()) {
                    notification.showBalloon(this.myNotificationTitle, "APK(s) generated successfully.", NotificationType.INFORMATION, new GoToPathHyperlink(apkPath));
                } else {
                    String msg = String.format("APK(s) location is\n%1$s.", apkPath.getPath());
                    notification.showBalloon(this.myNotificationTitle, msg, NotificationType.INFORMATION);
                }
            } else {
                String msg = "Errors while building APK. You can find the errors in the 'Messages' view.";
                notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
            }
        }
        finally {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
        }
    }

    private File getExistingApkPath() {
        for (File path : this.myPotentialApkLocations) {
            if (!path.isDirectory()) continue;
            return path;
        }
        String msg = String.format("None of the paths %1$s represent an existing directory", this.myPotentialApkLocations);
        throw new IllegalArgumentException(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToApkLocationTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoToPathHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final File myDirPath;

        protected GoToPathHyperlink(@NotNull File dirPath) {
            if (dirPath == null) {
                GoToPathHyperlink.$$$reportNull$$$0(0);
            }
            super("go.to.path", RevealFileAction.getActionName());
            this.myDirPath = dirPath;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                GoToPathHyperlink.$$$reportNull$$$0(1);
            }
            ShowFilePathAction.openDirectory((File)this.myDirPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToApkLocationTask$GoToPathHyperlink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

