/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.gradle;

import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum InstantRunGradleSupport {
    SUPPORTED,
    NO_GRADLE_MODEL,
    GRADLE_PLUGIN_TOO_OLD(AndroidBundle.message("instant.run.notification.ir.disabled.plugin.too.old", "2.3.0-beta1")),
    VARIANT_DOES_NOT_SUPPORT_INSTANT_RUN(AndroidBundle.message("instant.run.notification.ir.disabled.for.current.variant", new Object[0])),
    LEGACY_MULTIDEX_REQUIRES_ART(AndroidBundle.message("instant.run.notification.ir.disabled.multidex.requires.21", new Object[0])),
    CANNOT_BUILD_FOR_MULTIPLE_DEVICES(AndroidBundle.message("instant.run.notification.ir.disabled.multiple.devices", new Object[0])),
    CANNOT_DEPLOY_FOR_SECONDARY_USER(AndroidBundle.message("instant.run.notification.ir.disabled.secondary.user", new Object[0])),
    TARGET_PLATFORM_NOT_INSTALLED(AndroidBundle.message("instant.run.notification.ir.disabled.target.platform.missing", new Object[0])),
    API_TOO_LOW_FOR_INSTANT_RUN,
    NON_DEBUG_VARIANT(AndroidBundle.message("instant.run.notification.ir.disabled.non.debug.variant", new Object[0])),
    VARIANT_USED_FOR_TESTING(AndroidBundle.message("instant.run.notification.ir.disabled.testing.variant", new Object[0])),
    USES_JACK(AndroidBundle.message("instant.run.notification.ir.disabled.jack", new Object[0])),
    USES_EXTERNAL_NATIVE_BUILD(AndroidBundle.message("instant.run.notification.ir.disabled.external.native.build", new Object[0])),
    USES_EXPERIMENTAL_PLUGIN(AndroidBundle.message("instant.run.notification.ir.disabled.experimental.plugin", new Object[0])),
    UNKNOWN_REASON(AndroidBundle.message("instant.run.notification.ir.disabled.unknown.reason", new Object[0]));

    private final String myUserNotification;

    private InstantRunGradleSupport() {
        this(null);
    }

    private InstantRunGradleSupport(String userNotification) {
        this.myUserNotification = userNotification;
    }

    @Nullable
    public String getUserNotification() {
        return this.myUserNotification;
    }

    public static InstantRunGradleSupport fromModel(@NotNull AndroidModuleModel model) throws UnsupportedOperationException {
        int modelStatus;
        boolean modelSupportsInstantRun;
        if (model == null) {
            InstantRunGradleSupport.$$$reportNull$$$0(0);
        }
        if (!(modelSupportsInstantRun = InstantRunGradleUtils.modelSupportsInstantRun(model))) {
            return GRADLE_PLUGIN_TOO_OLD;
        }
        try {
            modelStatus = model.getSelectedVariant().getMainArtifact().getInstantRun().getSupportStatus();
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(String.format("This gradle model (%1$s) does not support querying for instant run status", model.getModelVersion()));
        }
        switch (modelStatus) {
            case 1: {
                return NON_DEBUG_VARIANT;
            }
            case 2: {
                return VARIANT_USED_FOR_TESTING;
            }
            case 3: {
                return USES_JACK;
            }
            case 4: {
                return USES_EXTERNAL_NATIVE_BUILD;
            }
            case 5: {
                return USES_EXPERIMENTAL_PLUGIN;
            }
            case 0: {
                return SUPPORTED;
            }
        }
        Logger.getInstance(InstantRunGradleSupport.class).error("Unknown instant run support status reported: " + modelStatus);
        return UNKNOWN_REASON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/gradle/InstantRunGradleSupport", "fromModel"));
    }
}

