/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class LogcatRecorder {
    private static final int BUFSIZE = 8192;
    private final Object LOCK;
    private final EvictingQueue<String> myLogs;
    private final AndroidLogcatService myLogcatService;
    private AtomicReference<IDevice> myDeviceRef;
    private AndroidLogcatService.LogcatListener myLogListener;

    public LogcatRecorder(@NotNull AndroidLogcatService logcatService) {
        if (logcatService == null) {
            LogcatRecorder.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myLogs = EvictingQueue.create((int)8192);
        this.myDeviceRef = new AtomicReference();
        this.myLogcatService = logcatService;
        this.myLogListener = new MyLogLineListener();
    }

    public void startMonitoring(@NotNull IDevice device, @NotNull LocalDateTime buildTimeStamp) {
        IDevice old;
        if (device == null) {
            LogcatRecorder.$$$reportNull$$$0(1);
        }
        if (buildTimeStamp == null) {
            LogcatRecorder.$$$reportNull$$$0(2);
        }
        if ((old = this.myDeviceRef.getAndSet(device)) != device) {
            if (old != null) {
                this.myLogcatService.removeListener(old, this.myLogListener);
            }
            this.myLogcatService.addListener(device, this.myLogListener);
            LogcatRecorder.enableInstantRunLog(device);
        }
        this.addLog("------------Launch on " + device.getName() + " @ " + buildTimeStamp.toString());
    }

    private static void enableInstantRunLog(IDevice device) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                device.executeShellCommand("setprop log.tag.InstantRun VERBOSE", (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLogs() {
        Object object = this.LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.myLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLog(@NotNull String s) {
        if (s == null) {
            LogcatRecorder.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myLogs.add((Object)s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logcatService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTimeStamp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/fd/LogcatRecorder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startMonitoring";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyLogLineListener
    implements AndroidLogcatService.LogcatListener {
        private MyLogLineListener() {
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage line) {
            if (line == null) {
                MyLogLineListener.$$$reportNull$$$0(0);
            }
            if ("InstantRun".equals(line.getTag())) {
                LogcatRecorder.this.addLog(line.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/fd/LogcatRecorder$MyLogLineListener", "onLogLineReceived"));
        }
    }
}

