/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl;

import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.ConditionCheckNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNodeUtil;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ConditionFalseNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ConditionTrueNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.GraphNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;

public class ConditionCheckNodeImpl
extends GraphNodeImpl
implements ConditionCheckNode {
    protected ConditionTrueNode mTrueNode;
    protected ConditionFalseNode mFalseNode;
    protected Value mCheckedValue;

    @Override
    public Value getCheckedValue() {
        return this.mCheckedValue;
    }

    @Override
    public GraphNode getTrueBranch() {
        return this.mTrueNode;
    }

    @Override
    public GraphNode getFalseBranch() {
        return this.mFalseNode;
    }

    @Override
    public GraphNode[] getOut() {
        GraphNode[] retArray = new GraphNode[]{this.mTrueNode, this.mFalseNode};
        return retArray;
    }

    @Override
    public void addOut(GraphNode out) {
    }

    @Override
    public void removeOut(GraphNode out) {
    }

    @Override
    public String getSimpleName() {
        return String.format("ConditionCheck on %s", this.mCheckedValue.getSimpleName());
    }

    public ConditionCheckNodeImpl(BlockGraph parentGraph, Value checkedVal) {
        super(parentGraph);
        this.mCheckedValue = checkedVal;
        this.mTrueNode = new ConditionTrueNode(parentGraph);
        this.mFalseNode = new ConditionFalseNode(parentGraph);
        GraphNodeUtil.connectGraphNode(this, this.mTrueNode);
        GraphNodeUtil.connectGraphNode(this, this.mFalseNode);
    }
}

