/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace;

import com.android.tools.idea.editors.vmtrace.TraceViewPanel;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.VmTraceParser;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VmTraceEditor
implements FileEditor {
    private final TraceViewPanel myTraceViewPanel;

    public VmTraceEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            VmTraceEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VmTraceEditor.$$$reportNull$$$0(1);
        }
        this.myTraceViewPanel = new TraceViewPanel(project);
        this.parseTraceFileInBackground(project, file);
    }

    private void parseTraceFileInBackground(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            VmTraceEditor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            VmTraceEditor.$$$reportNull$$$0(3);
        }
        final Task.Modal parseTask = new Task.Modal(project, "Parsing trace file", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                File traceFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                VmTraceParser parser = new VmTraceParser(traceFile);
                try {
                    parser.parse();
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Unexpected error while parsing trace file: " + Throwables.getRootCause((Throwable)throwable).getMessage()), (String)VmTraceEditor.this.getName());
                        }
                    }, ModalityState.defaultModalityState());
                    return;
                }
                final VmTraceData vmTraceData = parser.getTraceData();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VmTraceEditor.this.myTraceViewPanel.setTrace(vmTraceData);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/vmtrace/VmTraceEditor$1", "run"));
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTraceViewPanel.getComponent();
        if (jComponent == null) {
            VmTraceEditor.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("Traceview" == null) {
            VmTraceEditor.$$$reportNull$$$0(5);
        }
        return "Traceview";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            VmTraceEditor.$$$reportNull$$$0(6);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            VmTraceEditor.$$$reportNull$$$0(7);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            VmTraceEditor.$$$reportNull$$$0(8);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            VmTraceEditor.$$$reportNull$$$0(9);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            VmTraceEditor.$$$reportNull$$$0(10);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            VmTraceEditor.$$$reportNull$$$0(11);
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            VmTraceEditor.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/vmtrace/VmTraceEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/vmtrace/VmTraceEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTraceFileInBackground";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

