/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedValue
implements RestrictedQualifier {
    private int myMinValue;
    private int myMaxValue;

    RestrictedValue() {
        this.myMinValue = 0;
        this.myMaxValue = Integer.MAX_VALUE;
    }

    RestrictedValue(int minValue, int maxValue) {
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    private static int getValue(ResourceQualifier qualifier) {
        if (qualifier instanceof VersionQualifier) {
            return ((VersionQualifier)qualifier).getVersion();
        }
        return (Integer)QualifierUtils.getValue(qualifier);
    }

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (incompatibles == null) {
            RestrictedValue.$$$reportNull$$$0(0);
        }
        if (compatible != null) {
            this.myMinValue = RestrictedValue.getValue(compatible);
        }
        for (ResourceQualifier qualifier : incompatibles) {
            int value = RestrictedValue.getValue(qualifier);
            if (value <= this.myMinValue) continue;
            this.myMaxValue = Math.min(this.myMaxValue, value - 1);
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (qualifier == null) {
            return false;
        }
        int value = RestrictedValue.getValue(qualifier);
        return this.myMinValue <= value && value <= this.myMaxValue;
    }

    @Override
    public boolean isEmpty() {
        return this.myMinValue > this.myMaxValue;
    }

    @Override
    @Nullable
    public Object getAny() {
        if (this.myMinValue == 0 && this.myMaxValue == Integer.MAX_VALUE) {
            return null;
        }
        if (this.myMaxValue != Integer.MAX_VALUE) {
            return this.myMaxValue;
        }
        return this.myMinValue;
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestricted) {
        int resultMaxValue;
        if (otherRestricted == null) {
            RestrictedValue.$$$reportNull$$$0(1);
        }
        assert (otherRestricted instanceof RestrictedValue);
        int resultMinValue = Math.max(this.myMinValue, ((RestrictedValue)otherRestricted).myMinValue);
        if (resultMinValue > (resultMaxValue = Math.min(this.myMaxValue, ((RestrictedValue)otherRestricted).myMaxValue))) {
            return null;
        }
        return new RestrictedValue(resultMinValue, resultMaxValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedValue that = (RestrictedValue)o;
        if (this.myMinValue != that.myMinValue) {
            return false;
        }
        return this.myMaxValue == that.myMaxValue;
    }

    public int hashCode() {
        int result = this.myMinValue;
        result = 31 * result + this.myMaxValue;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRestricted";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/theme/qualifiers/RestrictedValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setRestrictions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "intersect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

