/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.editors.ColorPaletteComponent;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.ResourceHelper;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleListPaletteCellRenderer
extends StyleListCellRenderer {
    private static final String PRIMARY_MATERIAL = "colorPrimary";
    private static final String PRIMARY_DARK_MATERIAL = "colorPrimaryDark";
    private static final String ACCENT_MATERIAL = "colorAccent";
    private ColorPaletteComponent myColorPaletteComponent;
    @NotNull
    private final ThemeSelectionPanel.ThemeChangedListener myThemeChangedListener;
    @NotNull
    private final ThemeEditorContext myContext;

    public StyleListPaletteCellRenderer(@NotNull ThemeEditorContext context, @NotNull ThemeSelectionPanel.ThemeChangedListener themeChangedListener, @Nullable JComboBox comboBox) {
        if (context == null) {
            StyleListPaletteCellRenderer.$$$reportNull$$$0(0);
        }
        if (themeChangedListener == null) {
            StyleListPaletteCellRenderer.$$$reportNull$$$0(1);
        }
        super(context, comboBox);
        this.myColorPaletteComponent = null;
        this.myContext = context;
        this.myColorPaletteComponent = new ColorPaletteComponent();
        this.myThemeChangedListener = themeChangedListener;
    }

    @Override
    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.customizeCellRenderer(list, value, index, selected, hasFocus);
        if (!(value instanceof String) || ThemesListModel.isSpecialOption((String)value)) {
            this.myColorPaletteComponent.reset();
            return;
        }
        ThemeResolver themeResolver = this.myContext.getThemeResolver();
        ConfiguredThemeEditorStyle theme = themeResolver.getTheme((String)value);
        if (theme == null) {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
            return;
        }
        boolean isFrameworkAttr = !ThemeEditorUtils.isAppCompatTheme(theme);
        ItemResourceValue primaryResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_MATERIAL, isFrameworkAttr);
        ItemResourceValue primaryDarkResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_DARK_MATERIAL, isFrameworkAttr);
        ItemResourceValue accentResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, ACCENT_MATERIAL, isFrameworkAttr);
        if (primaryResourceValue != null && primaryDarkResourceValue != null && accentResourceValue != null) {
            Configuration configuration = theme.getConfiguration();
            ResourceResolver resourceResolver = configuration.getConfigurationManager().getResolverCache().getResourceResolver(configuration.getRealTarget(), theme.getStyleResourceUrl(), configuration.getFullConfig());
            Color primaryColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryResourceValue, this.myContext.getProject());
            Color primaryDarkColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryDarkResourceValue, this.myContext.getProject());
            Color accentColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)accentResourceValue, this.myContext.getProject());
            if (primaryColor != null && primaryDarkColor != null && accentColor != null) {
                this.myColorPaletteComponent.setValues(primaryColor, primaryDarkColor, accentColor);
            }
            this.setIcon(this.myColorPaletteComponent);
        } else {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
        }
        if (selected) {
            this.myThemeChangedListener.themeChanged(theme.getQualifiedName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "themeChangedListener";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/editors/theme/attributes/editors/StyleListPaletteCellRenderer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

