/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorContext
implements Disposable {
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    private ConfiguredThemeEditorStyle myCurrentTheme;
    @NotNull
    private ThemeResolver myThemeResolver;
    private final List<ChangeListener> myChangeListeners;
    private final List<ConfigurationListener> myConfigurationListeners;
    private boolean myEnabledListeners;
    private final ConfigurationListener myConfigurationListener;

    public ThemeEditorContext(@NotNull Configuration configuration) {
        if (configuration == null) {
            ThemeEditorContext.$$$reportNull$$$0(0);
        }
        this.myChangeListeners = new ArrayList<ChangeListener>();
        this.myConfigurationListeners = new ArrayList<ConfigurationListener>();
        this.myEnabledListeners = true;
        this.myConfigurationListener = new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if (!ThemeEditorContext.this.myEnabledListeners) {
                    return true;
                }
                boolean accepted = true;
                for (ConfigurationListener listener : ThemeEditorContext.this.myConfigurationListeners) {
                    accepted &= listener.changed(flags);
                }
                return accepted;
            }
        };
        this.setConfiguration(configuration);
        this.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((0xF6 & flags) != 0) {
                    ThemeEditorContext.this.updateThemeResolver();
                }
                return true;
            }
        });
    }

    public void updateThemeResolver() {
        this.myEnabledListeners = false;
        Configuration resolverConfiguration = this.myConfiguration.clone();
        resolverConfiguration.setTheme(null);
        this.myEnabledListeners = true;
        this.myThemeResolver = new ThemeResolver(resolverConfiguration);
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ThemeEditorContext.$$$reportNull$$$0(1);
        }
        return configuration;
    }

    @NotNull
    public Module getCurrentContextModule() {
        Module module = this.myConfiguration.getModule();
        if (module == null) {
            ThemeEditorContext.$$$reportNull$$$0(2);
        }
        return module;
    }

    public void setCurrentTheme(@Nullable ConfiguredThemeEditorStyle currentTheme) {
        this.myCurrentTheme = currentTheme;
    }

    @Nullable
    public ConfiguredThemeEditorStyle getCurrentTheme() {
        return this.myCurrentTheme;
    }

    @NotNull
    public Module getModuleForResources() {
        if (this.myCurrentTheme != null && this.myCurrentTheme.getSourceModule() != null) {
            Module module = this.myCurrentTheme.getSourceModule();
            if (module == null) {
                ThemeEditorContext.$$$reportNull$$$0(3);
            }
            return module;
        }
        Module module = this.myConfiguration.getModule();
        if (module == null) {
            ThemeEditorContext.$$$reportNull$$$0(4);
        }
        return module;
    }

    public void setCurrentContextModule(@NotNull Module module) {
        if (module == null) {
            ThemeEditorContext.$$$reportNull$$$0(5);
        }
        this.setConfiguration(ThemeEditorUtils.getConfigurationForModule(module));
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        if (this.getCurrentContextModule().isDisposed()) {
            return null;
        }
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myConfiguration.getModule().getProject();
        if (project == null) {
            ThemeEditorContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    public void addConfigurationListener(@NotNull ConfigurationListener configurationListener) {
        if (configurationListener == null) {
            ThemeEditorContext.$$$reportNull$$$0(7);
        }
        this.myConfigurationListeners.add(configurationListener);
    }

    @NotNull
    public ThemeResolver getThemeResolver() {
        ThemeResolver themeResolver = this.myThemeResolver;
        if (themeResolver == null) {
            ThemeEditorContext.$$$reportNull$$$0(8);
        }
        return themeResolver;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            ThemeEditorContext.$$$reportNull$$$0(9);
        }
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this.myConfigurationListener);
        }
        this.myConfiguration = configuration;
        this.updateThemeResolver();
        this.myConfiguration.addListener(this.myConfigurationListener);
        this.fireNewConfiguration();
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    private void fireNewConfiguration() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.onNewConfiguration(this);
        }
    }

    public void dispose() {
        this.myConfiguration.removeListener(this.myConfigurationListener);
        this.myConfigurationListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContextModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleForResources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentContextModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeListener {
        public void onNewConfiguration(ThemeEditorContext var1);
    }
}

