/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditor
extends UserDataHolderBase
implements FileEditor {
    private final ThemeEditorVirtualFile myVirtualFile;
    private final ThemeEditorComponent myComponent;

    public ThemeEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ThemeEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ThemeEditor.$$$reportNull$$$0(1);
        }
        this.myVirtualFile = (ThemeEditorVirtualFile)file;
        this.myComponent = new ThemeEditorComponent(project);
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorStyle theme = null;
                        ThemeEditorStyle subStyle = null;
                        if (!ThemeEditor.this.myComponent.getSelectedModule().isDisposed()) {
                            if (ModuleRootManager.getInstance((Module)ThemeEditor.this.myComponent.getSelectedModule()).getSdk() == null) {
                                return;
                            }
                            theme = ThemeEditor.this.myComponent.getSelectedTheme();
                            subStyle = ThemeEditor.this.myComponent.getCurrentSubStyle();
                        }
                        ThemeEditor.this.myComponent.reload(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName());
                    }
                });
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        ThemeEditorComponent themeEditorComponent = this.myComponent;
        if (themeEditorComponent == null) {
            ThemeEditor.$$$reportNull$$$0(2);
        }
        return themeEditorComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("Theme Editor" == null) {
            ThemeEditor.$$$reportNull$$$0(3);
        }
        return "Theme Editor";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel fileEditorStateLevel) {
        if (fileEditorStateLevel == null) {
            ThemeEditor.$$$reportNull$$$0(4);
        }
        ConfiguredThemeEditorStyle theme = this.myComponent.getSelectedTheme();
        ConfiguredThemeEditorStyle subStyle = this.myComponent.getCurrentSubStyle();
        ThemeEditorState themeEditorState = new ThemeEditorState(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName(), Float.valueOf(this.myComponent.getProportion()), this.myComponent.getSelectedModule().getName());
        if (themeEditorState == null) {
            ThemeEditor.$$$reportNull$$$0(5);
        }
        return themeEditorState;
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
        if (fileEditorState == null) {
            ThemeEditor.$$$reportNull$$$0(6);
        }
        if (!(fileEditorState instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState state = (ThemeEditorState)fileEditorState;
        this.myComponent.reload(state.getThemeName(), state.getSubStyleName(), state.getModuleName());
        this.myComponent.setProportion(state.getProportion());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
        this.myComponent.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            ThemeEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            ThemeEditor.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public ThemeEditorVirtualFile getVirtualFile() {
        ThemeEditorVirtualFile themeEditorVirtualFile = this.myVirtualFile;
        if (themeEditorVirtualFile == null) {
            ThemeEditor.$$$reportNull$$$0(9);
        }
        return themeEditorVirtualFile;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorStateLevel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorState";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyChangeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

