/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestUtils {
    private ManifestUtils() {
    }

    @NotNull
    static List<? extends Actions.Record> getRecords(@NotNull MergedManifest manifest, @NotNull Node item) {
        Actions actions;
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(1);
        }
        if ((actions = manifest.getActions()) != null) {
            if (item instanceof Element) {
                Element element = (Element)item;
                XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
                ImmutableList immutableList = actions.getNodeRecords(key);
                if (immutableList == null) {
                    ManifestUtils.$$$reportNull$$$0(2);
                }
                return immutableList;
            }
            if (item instanceof Attr) {
                XmlNode.NodeName name;
                Attr attribute = (Attr)item;
                Element element = attribute.getOwnerElement();
                XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
                ImmutableList attributeRecords = actions.getAttributeRecords(key, name = XmlNode.fromXmlName((String)attribute.getName()));
                if (!attributeRecords.isEmpty()) {
                    ImmutableList immutableList = attributeRecords;
                    if (immutableList == null) {
                        ManifestUtils.$$$reportNull$$$0(3);
                    }
                    return immutableList;
                }
                ImmutableList immutableList = actions.getNodeRecords(key);
                if (immutableList == null) {
                    ManifestUtils.$$$reportNull$$$0(4);
                }
                return immutableList;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            ManifestUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    static XmlNode.NodeKey getNodeKey(@NotNull MergedManifest manifest, @NotNull Element element) {
        XmlNode.NodeKey key;
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ManifestUtils.$$$reportNull$$$0(7);
        }
        if ((key = manifest.getNodeKey(element.getNodeName())) == null) {
            Attr nameAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (nameAttribute != null) {
                key = manifest.getNodeKey(element.getTagName() + "#" + nameAttribute.getValue());
            } else {
                Attr glEsVersionAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion");
                if (glEsVersionAttribute != null) {
                    key = manifest.getNodeKey(element.getTagName() + "#" + glEsVersionAttribute.getValue());
                } else {
                    NodeList children = element.getChildNodes();
                    ArrayList<String> names = new ArrayList<String>(children.getLength());
                    for (int i = 0; i < children.getLength(); ++i) {
                        Attr childAttribute;
                        Node child = children.item(i);
                        if (child.getNodeType() != 1 || (childAttribute = ((Element)child).getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null) continue;
                        names.add(childAttribute.getValue());
                    }
                    Collections.sort(names);
                    key = manifest.getNodeKey(element.getTagName() + "#" + Joiner.on((char)'+').join(names));
                }
            }
        }
        return key;
    }

    @NotNull
    static SourceFilePosition getActionLocation(@NotNull Module module, @NotNull Actions.Record record) {
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(8);
        }
        if (record == null) {
            ManifestUtils.$$$reportNull$$$0(9);
        }
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
            if (fileModule != null && !fileModule.equals(module)) {
                int startColumn;
                MergedManifest manifest = MergedManifest.get(fileModule);
                Document document = manifest.getDocument();
                assert (document != null);
                Element root = document.getDocumentElement();
                assert (root != null);
                int startLine = sourcePosition.getStartLine();
                Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)(startColumn = sourcePosition.getStartColumn()));
                if (node == null) {
                    Logger.getInstance(ManifestPanel.class).warn("Can not find node in " + fileModule + " for " + sourceFilePosition);
                } else {
                    List<? extends Actions.Record> records = ManifestUtils.getRecords(manifest, node);
                    if (!records.isEmpty()) {
                        SourceFilePosition sourceFilePosition2 = ManifestUtils.getActionLocation(fileModule, records.get(0));
                        if (sourceFilePosition2 == null) {
                            ManifestUtils.$$$reportNull$$$0(10);
                        }
                        return sourceFilePosition2;
                    }
                }
            }
        }
        SourceFilePosition sourceFilePosition3 = sourceFilePosition;
        if (sourceFilePosition3 == null) {
            ManifestUtils.$$$reportNull$$$0(11);
        }
        return sourceFilePosition3;
    }

    @Nullable
    public static IdeaSourceProvider findManifestSourceProvider(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        if (facet == null) {
            ManifestUtils.$$$reportNull$$$0(12);
        }
        if (manifestFile == null) {
            ManifestUtils.$$$reportNull$$$0(13);
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            if (!manifestFile.equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static XmlFile getMainManifest(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ManifestUtils.$$$reportNull$$$0(14);
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        assert (manifestFile != null);
        PsiFile psiFile = PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestFile);
        assert (psiFile != null);
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            ManifestUtils.$$$reportNull$$$0(15);
        }
        return xmlFile;
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Node item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(16);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (item instanceof Element) {
            ManifestUtils.toolsRemove(manifest, (Element)item);
        } else if (item instanceof Attr) {
            Attr attribute = (Attr)item;
            Element element = attribute.getOwnerElement();
            if ("name".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || LintUtils.getChildCount((Node)element) == 0 && element.getAttributes().getLength() == 1) {
                ManifestUtils.toolsRemove(manifest, element);
            } else {
                ManifestUtils.toolsRemove(manifest, attribute);
            }
        }
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Element item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(18);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(19);
        }
        ManifestUtils.addToolsAttribute(manifest, item, "node", "remove");
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Attr item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(20);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(21);
        }
        ManifestUtils.addToolsAttribute(manifest, item.getOwnerElement(), "remove", item.getName());
    }

    static void addToolsAttribute(@NotNull XmlFile manifest, @NotNull Element item, @NotNull String attributeName, @NotNull String attributeValue) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(22);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(23);
        }
        if (attributeName == null) {
            ManifestUtils.$$$reportNull$$$0(24);
        }
        if (attributeValue == null) {
            ManifestUtils.$$$reportNull$$$0(25);
        }
        if (attributeName.contains(":")) {
            throw new IllegalArgumentException("should not have namespace as it's always tools");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        AndroidResourceUtil.ensureNamespaceImported(manifest, "http://schemas.android.com/tools", null);
        XmlTag parent = null;
        XmlTag[] manifestTags = new XmlTag[]{manifest.getRootTag()};
        for (Element tag : ManifestUtils.getPath(item)) {
            XmlTag found = ManifestUtils.findTag(manifestTags, tag);
            if (found == null) {
                if (parent == null) {
                    Logger.getInstance(ManifestUtils.class).warn("can not root tag " + tag + " in xml file " + manifest);
                    return;
                }
                found = parent.createChildTag(tag.getLocalName(), null, null, false);
                found = parent.addSubTag(found, true);
                Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameAttribute != null) {
                    found.setAttribute(nameAttribute.getLocalName(), nameAttribute.getNamespaceURI(), nameAttribute.getValue());
                }
                if (tag == item) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                }
            } else if (tag == item) {
                XmlAttribute attribute = found.getAttribute(attributeName, "http://schemas.android.com/tools");
                if (attribute == null) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                } else {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attribute.getValue() + "," + attributeValue);
                }
            }
            parent = found;
            manifestTags = found.getSubTags();
        }
    }

    @Nullable
    private static XmlTag findTag(@NotNull XmlTag[] manifestTags, @NotNull Element tag) {
        Attr nameAttribute;
        if (manifestTags == null) {
            ManifestUtils.$$$reportNull$$$0(26);
        }
        if (tag == null) {
            ManifestUtils.$$$reportNull$$$0(27);
        }
        String name = (nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null ? null : nameAttribute.getValue();
        for (XmlTag xmlTag : manifestTags) {
            if (!tag.getTagName().equals(xmlTag.getName())) continue;
            if (name != null) {
                XmlAttribute xmlAttribute = xmlTag.getAttribute("name", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null || !name.equals(xmlAttribute.getValue())) continue;
                return xmlTag;
            }
            return xmlTag;
        }
        return null;
    }

    @NotNull
    private static List<Element> getPath(@NotNull Element element) {
        if (element == null) {
            ManifestUtils.$$$reportNull$$$0(28);
        }
        Element tag = element;
        ArrayList<Element> path = new ArrayList<Element>();
        while (true) {
            path.add(tag);
            Node parentNode = tag.getParentNode();
            if (!(parentNode instanceof Element)) break;
            tag = (Element)parentNode;
        }
        Collections.reverse(path);
        ArrayList<Element> arrayList = path;
        if (arrayList == null) {
            ManifestUtils.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 1: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/manifest/ManifestUtils";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestTags";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecords";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionLocation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainManifest";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRecords";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 29: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeKey";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionLocation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findManifestSourceProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMainManifest";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toolsRemove";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToolsAttribute";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findTag";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

