/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiClassNavigation;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapClassObjNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapPackageNode;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassesTreeView
implements DataProvider,
Disposable {
    public static final String TREE_NAME = "HprofClassesTree";
    @NotNull
    private Project myProject;
    @NotNull
    private Tree myTree;
    @NotNull
    private DefaultTreeModel myTreeModel;
    @NotNull
    private HeapPackageNode myRoot;
    @NotNull
    private JComponent myColumnTree;
    @Nullable
    private Comparator<HeapNode> myComparator;
    private int mySelectedHeapId;
    @NotNull
    private ListIndex myListIndex;
    @NotNull
    private TreeIndex myTreeIndex;
    @NotNull
    private DisplayMode myDisplayMode;

    public ClassesTreeView(@NotNull Project project, @NotNull DefaultActionGroup editorActionGroup, final @NotNull SelectionModel selectionModel) {
        if (project == null) {
            ClassesTreeView.$$$reportNull$$$0(0);
        }
        if (editorActionGroup == null) {
            ClassesTreeView.$$$reportNull$$$0(1);
        }
        if (selectionModel == null) {
            ClassesTreeView.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoot = new HeapPackageNode(null, "");
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setName(TREE_NAME);
        this.myDisplayMode = DisplayMode.LIST;
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setLargeModel(true);
        this.myTree.putClientProperty((Object)"DataProvider", (Object)this);
        JBList contextActionList = new JBList(new Object[]{new EditMultipleSourcesAction()});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)contextActionList);
        final DefaultActionGroup popupGroup = new DefaultActionGroup(new AnAction[]{new EditMultipleSourcesAction()});
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        editorActionGroup.addAction((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (final DisplayMode mode : DisplayMode.values()) {
                    group.add(new AnAction(mode.toString()){

                        public void actionPerformed(AnActionEvent e) {
                            ClassesTreeView.this.myDisplayMode = mode;
                            boolean isTreeMode = ClassesTreeView.this.myDisplayMode == DisplayMode.TREE;
                            ClassesTreeView.this.myTree.setShowsRootHandles(isTreeMode);
                            if (isTreeMode) {
                                ClassesTreeView.this.myTreeIndex.buildTree(ClassesTreeView.this.mySelectedHeapId);
                            } else {
                                ClassesTreeView.this.myListIndex.buildList(ClassesTreeView.this.myRoot);
                            }
                            ClassesTreeView.this.restoreViewState(selectionModel);
                        }
                    });
                }
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    2.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(ClassesTreeView.this.myDisplayMode.toString());
                e.getPresentation().setText(ClassesTreeView.this.myDisplayMode.toString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$2", "createPopupActionGroup"));
            }
        });
        this.myListIndex = new ListIndex();
        this.myTreeIndex = new TreeIndex();
        selectionModel.addListener(this.myListIndex);
        selectionModel.addListener(this.myTreeIndex);
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(@NotNull Heap heap) {
                if (heap == null) {
                    3.$$$reportNull$$$0(0);
                }
                ClassesTreeView.this.mySelectedHeapId = heap.getId();
                assert (ClassesTreeView.this.myListIndex.myHeapId == ClassesTreeView.this.mySelectedHeapId);
                if (ClassesTreeView.this.myDisplayMode == DisplayMode.LIST) {
                    ClassesTreeView.this.myListIndex.buildList(ClassesTreeView.this.myRoot);
                } else if (ClassesTreeView.this.myDisplayMode == DisplayMode.TREE) {
                    ClassesTreeView.this.myTreeIndex.buildTree(ClassesTreeView.this.mySelectedHeapId);
                }
                ClassesTreeView.this.restoreViewState(selectionModel);
            }

            @Override
            public void onClassObjChanged(@Nullable ClassObj classObj) {
                HeapClassObjNode nodeToSelect = null;
                if (classObj != null) {
                    nodeToSelect = ClassesTreeView.this.findClassObjNode(classObj);
                }
                if (nodeToSelect != null) {
                    TreePath pathToSelect = new TreePath(ClassesTreeView.this.myTreeModel.getPathToRoot(nodeToSelect));
                    ClassesTreeView.this.myTree.setSelectionPath(pathToSelect);
                    ClassesTreeView.this.myTree.scrollPathToVisible(pathToSelect);
                }
            }

            @Override
            public void onInstanceChanged(@Nullable Instance instance) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$3", "onHeapChanged"));
            }
        });
        this.myTree.addTreeSelectionListener(e -> {
            if (selectionModel == null) {
                ClassesTreeView.$$$reportNull$$$0(9);
            }
            TreePath path = e.getPath();
            if (!e.isAddedPath()) {
                return;
            }
            if (path == null || path.getPathCount() < 2) {
                selectionModel.setClassObj(null);
                return;
            }
            assert (path.getLastPathComponent() instanceof HeapNode);
            HeapNode heapNode = (HeapNode)path.getLastPathComponent();
            if (heapNode instanceof HeapClassObjNode) {
                selectionModel.setClassObj(((HeapClassObjNode)heapNode).getClassObj());
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class Name").setPreferredWidth(800).setHeaderAlignment(2).setComparator((a, b) -> {
            int valueB;
            int valueA = a instanceof HeapPackageNode ? 0 : 1;
            int n = valueB = b instanceof HeapPackageNode ? 0 : 1;
            if (valueA != valueB) {
                return valueA - valueB;
            }
            return ClassesTreeView.compareNames(a, b);
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapClassObjNode) {
                    ClassObj clazz = ((HeapClassObjNode)value).getClassObj();
                    String name = clazz.getClassName();
                    String pkg = null;
                    int i = name.lastIndexOf(".");
                    if (i != -1) {
                        pkg = name.substring(0, i);
                        name = name.substring(i + 1);
                    }
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (pkg != null) {
                        this.append(" (" + pkg + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                    }
                    this.setTransparentIconBackground(true);
                    this.setIcon(PlatformIcons.CLASS_ICON);
                } else if (value instanceof HeapNode) {
                    this.append(((HeapNode)value).getSimpleName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setTransparentIconBackground(true);
                    this.setIcon(PlatformIcons.PACKAGE_ICON);
                } else {
                    this.append("This should not be rendered");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$9", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator((a, b) -> {
            int result = a.getTotalCount() - b.getTotalCount();
            return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getTotalCount()));
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$8", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Heap Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator((a, b) -> {
            int result = a.getHeapInstancesCount(this.mySelectedHeapId) - b.getHeapInstancesCount(this.mySelectedHeapId);
            return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getHeapInstancesCount(ClassesTreeView.this.mySelectedHeapId)));
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$7", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Sizeof").setPreferredWidth(80).setHeaderAlignment(4).setComparator((a, b) -> {
            int sizeA = a.getInstanceSize();
            int sizeB = b.getInstanceSize();
            if (sizeA < 0 && sizeB < 0) {
                return ClassesTreeView.compareNames(a, b);
            }
            int result = sizeA - sizeB;
            return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapClassObjNode) {
                    this.append(Integer.toString(((HeapClassObjNode)value).getInstanceSize()));
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$6", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(100).setHeaderAlignment(4).setComparator((a, b) -> {
            int result = a.getShallowSize(this.mySelectedHeapId) - b.getShallowSize(this.mySelectedHeapId);
            return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getShallowSize(ClassesTreeView.this.mySelectedHeapId)));
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$5", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Retained Size").setPreferredWidth(120).setHeaderAlignment(4).setInitialOrder(SortOrder.DESCENDING).setComparator((a, b) -> {
            long result = a.getRetainedSize() - b.getRetainedSize();
            return result == 0L ? ClassesTreeView.compareNames(a, b) : (result > 0L ? 1 : -1);
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value instanceof HeapNode) {
                    this.append(Long.toString(((HeapNode)value).getRetainedSize()));
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$4", "customizeCellRenderer"));
            }
        }));
        builder.setTreeSorter((ColumnTreeBuilder.TreeSorter)new ColumnTreeBuilder.TreeSorter<HeapNode>(){

            public void sort(@NotNull Comparator<HeapNode> comparator, @NotNull SortOrder sortOrder) {
                if (comparator == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (sortOrder == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (ClassesTreeView.this.myComparator != comparator) {
                    ClassesTreeView.this.myComparator = comparator;
                    selectionModel.setSelectionLocked(true);
                    TreePath selectionPath = ClassesTreeView.this.myTree.getSelectionPath();
                    ClassesTreeView.this.sortTree(ClassesTreeView.this.myRoot);
                    ClassesTreeView.this.myTreeModel.nodeStructureChanged(ClassesTreeView.this.myRoot);
                    ClassesTreeView.this.myTree.setSelectionPath(selectionPath);
                    ClassesTreeView.this.myTree.scrollPathToVisible(selectionPath);
                    selectionModel.setSelectionLocked(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "comparator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sortOrder";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/editors/hprof/views/ClassesTreeView$10";
                objectArray[2] = "sort";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myColumnTree = builder.build();
        this.installTreeSpeedSearch();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnTree;
        if (jComponent == null) {
            ClassesTreeView.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
    }

    private void installTreeSpeedSearch() {
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath e) {
                Object o = e.getLastPathComponent();
                if (o instanceof HeapNode) {
                    if (o instanceof HeapClassObjNode) {
                        return ((HeapClassObjNode)o).getSimpleName();
                    }
                    if (o instanceof HeapPackageNode) {
                        return ((HeapPackageNode)o).getFullName();
                    }
                }
                return o.toString();
            }
        }, true);
    }

    private void sortTree(@NotNull HeapPackageNode parent) {
        if (parent == null) {
            ClassesTreeView.$$$reportNull$$$0(4);
        }
        if (parent.isLeaf() || this.myComparator == null) {
            return;
        }
        List<HeapNode> children = parent.getChildren();
        Collections.sort(children, this.myComparator);
        for (HeapNode child : children) {
            if (!(child instanceof HeapPackageNode)) continue;
            this.sortTree((HeapPackageNode)child);
        }
    }

    private void restoreViewState(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            ClassesTreeView.$$$reportNull$$$0(5);
        }
        ClassObj classToSelect = selectionModel.getClassObj();
        HeapClassObjNode nodeToSelect = null;
        if (classToSelect != null) {
            nodeToSelect = this.findClassObjNode(classToSelect);
        }
        this.sortTree(this.myRoot);
        this.myTreeModel.nodeStructureChanged(this.myRoot);
        HeapClassObjNode targetNode = nodeToSelect;
        if (targetNode != null) {
            this.myColumnTree.revalidate();
            TreePath pathToSelect = new TreePath(this.myTreeModel.getPathToRoot(targetNode));
            this.myTree.setSelectionPath(pathToSelect);
            ApplicationManager.getApplication().invokeLater(() -> this.myTree.scrollPathToVisible(pathToSelect));
        } else {
            selectionModel.setClassObj(null);
            if (this.myTree.getRowCount() > 0) {
                this.myTree.scrollRowToVisible(0);
            }
        }
    }

    @Nullable
    private HeapClassObjNode findClassObjNode(@NotNull ClassObj targetClass) {
        block9: {
            block8: {
                if (targetClass == null) {
                    ClassesTreeView.$$$reportNull$$$0(6);
                }
                if (this.myDisplayMode != DisplayMode.LIST) break block8;
                for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                    TreeNode child = this.myRoot.getChildAt(i);
                    assert (child instanceof HeapClassObjNode);
                    if (((HeapClassObjNode)child).getClassObj() != targetClass) continue;
                    return (HeapClassObjNode)child;
                }
                break block9;
            }
            if (this.myDisplayMode != DisplayMode.TREE) break block9;
            HeapPackageNode currentNode = this.myRoot;
            String[] packages = targetClass.getClassName().split("\\.");
            assert (packages.length > 0);
            for (int currentPackageIndex = 0; currentPackageIndex < packages.length - 1; ++currentPackageIndex) {
                if (currentNode.getSubPackages().containsKey(packages[currentPackageIndex])) {
                    currentNode = currentNode.getSubPackages().get(packages[currentPackageIndex]);
                    continue;
                }
                return null;
            }
            for (int i = 0; i < currentNode.getChildCount(); ++i) {
                TreeNode childTreeNode = currentNode.getChildAt(i);
                assert (childTreeNode instanceof HeapNode);
                HeapNode child = (HeapNode)childTreeNode;
                if (!(child instanceof HeapClassObjNode) || ((HeapClassObjNode)child).getClassObj() != targetClass) continue;
                return (HeapClassObjNode)child;
            }
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    @Nullable
    private PsiClassNavigation[] getTargetFiles() {
        TreePath path = this.myTree.getSelectionPath();
        if (path.getPathCount() < 2) {
            return null;
        }
        assert (path.getLastPathComponent() instanceof HeapNode);
        HeapNode node = (HeapNode)path.getLastPathComponent();
        if (node instanceof HeapClassObjNode) {
            ClassObj classObj = ((HeapClassObjNode)node).getClassObj();
            String className = classObj.getClassName();
            int arrayIndex = className.indexOf("[");
            if (arrayIndex >= 0) {
                className = className.substring(0, arrayIndex);
            }
            return PsiClassNavigation.getNavigationForClass(this.myProject, className);
        }
        return null;
    }

    public void dispose() {
        this.myListIndex.clear();
        this.myTreeIndex.clear();
    }

    private static int compareNames(@NotNull HeapNode a, @NotNull HeapNode b) {
        int comparisonResult;
        if (a == null) {
            ClassesTreeView.$$$reportNull$$$0(7);
        }
        if (b == null) {
            ClassesTreeView.$$$reportNull$$$0(8);
        }
        if ((comparisonResult = a.getSimpleName().compareToIgnoreCase(b.getSimpleName())) == 0) {
            return a.getFullName().compareToIgnoreCase(b.getFullName());
        }
        return comparisonResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorActionGroup";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/views/ClassesTreeView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/views/ClassesTreeView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortTree";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreViewState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassObjNode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TreeIndex
    implements SelectionModel.SelectionListener {
        private int myHeapId = -1;

        private TreeIndex() {
        }

        @Override
        public void onHeapChanged(@NotNull Heap heap) {
            if (heap == null) {
                TreeIndex.$$$reportNull$$$0(0);
            }
            if (ClassesTreeView.this.myDisplayMode == DisplayMode.TREE) {
                assert (ClassesTreeView.this.myListIndex.myHeapId == heap.getId());
                this.buildTree(heap.getId());
            }
        }

        @Override
        public void onClassObjChanged(@Nullable ClassObj classObj) {
        }

        @Override
        public void onInstanceChanged(@Nullable Instance instance) {
        }

        private void buildTree(int heapId) {
            if (this.myHeapId != heapId) {
                this.myHeapId = heapId;
                ClassesTreeView.this.myRoot.clear();
                for (HeapClassObjNode heapClassObjNode : ((ClassesTreeView)ClassesTreeView.this).myListIndex.myClasses) {
                    ClassesTreeView.this.myRoot.classifyClassObj(heapClassObjNode);
                }
                ClassesTreeView.this.myRoot.update(ClassesTreeView.this.mySelectedHeapId);
            }
            ClassesTreeView.this.myRoot.buildTree();
        }

        private void clear() {
            ClassesTreeView.this.myRoot.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$TreeIndex", "onHeapChanged"));
        }
    }

    private static class ListIndex
    implements SelectionModel.SelectionListener {
        ArrayList<HeapClassObjNode> myClasses = new ArrayList();
        private int myHeapId = -1;

        private ListIndex() {
        }

        @Override
        public void onHeapChanged(@NotNull Heap heap) {
            if (heap == null) {
                ListIndex.$$$reportNull$$$0(0);
            }
            if (this.myHeapId != heap.getId()) {
                this.myHeapId = heap.getId();
                this.myClasses.clear();
                HashSet entriesSet = new HashSet(heap.getClasses().size() + heap.getInstancesCount());
                for (ClassObj classObj : heap.getClasses()) {
                    entriesSet.add((Object)classObj);
                }
                heap.forEachInstance(instance -> {
                    entriesSet.add((Object)instance.getClassObj());
                    return true;
                });
                for (ClassObj classObj : entriesSet) {
                    this.myClasses.add(new HeapClassObjNode(classObj, this.myHeapId));
                }
            }
        }

        @Override
        public void onClassObjChanged(@Nullable ClassObj classObj) {
        }

        @Override
        public void onInstanceChanged(@Nullable Instance instance) {
        }

        private void buildList(@NotNull HeapNode root) {
            if (root == null) {
                ListIndex.$$$reportNull$$$0(1);
            }
            root.removeAllChildren();
            for (HeapClassObjNode heapClassObjNode : this.myClasses) {
                heapClassObjNode.removeFromParent();
                root.add(heapClassObjNode);
            }
        }

        private void clear() {
            this.myClasses.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "heap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/hprof/views/ClassesTreeView$ListIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onHeapChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum DisplayMode {
        LIST("Class List View"),
        TREE("Package Tree View");

        @NotNull
        private String myName;

        private DisplayMode(String name) {
            if (name == null) {
                DisplayMode.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/hprof/views/ClassesTreeView$DisplayMode", "<init>"));
        }
    }
}

