/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.StackNode;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class StackSourceNode
extends AbstractTreeNode {
    @NotNull
    private Map<String, AllocNode> mySimilarObjectsMap = new HashMap<String, AllocNode>();
    @NotNull
    protected Map<StackTraceElement, StackNode> myChildrenMap = new HashMap<StackTraceElement, StackNode>();

    public void insert(@NotNull AllocationInfo alloc, int depth) {
        StackTraceElement[] stack;
        if (alloc == null) {
            StackSourceNode.$$$reportNull$$$0(0);
        }
        if (depth < (stack = alloc.getStackTrace()).length) {
            StackTraceElement element = stack[stack.length - 1 - depth];
            StackNode child = this.myChildrenMap.get(element);
            if (child == null) {
                child = new StackNode(element);
                this.myChildrenMap.put(element, child);
                this.insertChild(child);
            }
            child.insert(alloc, depth + 1);
        } else {
            this.insertChild(new AllocNode(alloc));
        }
    }

    @Override
    protected void addChild(@NotNull AbstractTreeNode node) {
        if (node == null) {
            StackSourceNode.$$$reportNull$$$0(1);
        }
        if (node instanceof AllocNode) {
            AllocationInfo allocInfo = ((AllocNode)node).getAllocation();
            String key = String.format("%s,%s", allocInfo.getAllocatedClass(), allocInfo.getSize());
            if (this.mySimilarObjectsMap.containsKey(key)) {
                this.mySimilarObjectsMap.get(key).incrementCount();
            } else {
                super.addChild(node);
                this.mySimilarObjectsMap.put(key, (AllocNode)node);
            }
        } else {
            super.addChild(node);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alloc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/allocations/nodes/StackSourceNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

