/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.ByteBufferUtil;
import com.android.tools.idea.editors.allocations.AllocationsView;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsEditor
implements FileEditor {
    private final JPanel myPanel;

    public AllocationsEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AllocationsEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AllocationsEditor.$$$reportNull$$$0(1);
        }
        this.myPanel = new JPanel(new BorderLayout());
        this.parseAllocationsFileInBackground(project, file);
    }

    private void parseAllocationsFileInBackground(final Project project, final VirtualFile file) {
        Task.Modal parseTask = new Task.Modal(project, "Parsing allocations file", false){
            private AllocationInfo[] myAllocations;
            private String myErrorMessage;

            public void run(@NotNull ProgressIndicator indicator) {
                ByteBuffer data;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                File allocationsFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    data = ByteBufferUtil.mapFile((File)allocationsFile, (long)0L, (ByteOrder)ByteOrder.BIG_ENDIAN);
                }
                catch (IOException ex) {
                    this.myErrorMessage = "Error reading from allocations file " + allocationsFile.getAbsolutePath();
                    throw new ProcessCanceledException();
                }
                if (AllocationsParser.hasOverflowedNumEntriesBug((ByteBuffer)data)) {
                    this.myErrorMessage = "Invalid allocations file detected. Please refer to https://code.google.com/p/android/issues/detail?id=204503 for details.";
                    throw new ProcessCanceledException();
                }
                try {
                    this.myAllocations = AllocationsParser.parse((ByteBuffer)data);
                }
                catch (Throwable throwable) {
                    this.myErrorMessage = "Unexpected error while parsing allocations file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    throw new ProcessCanceledException();
                }
            }

            public void onSuccess() {
                AllocationsView view = new AllocationsView(project, this.myAllocations);
                AllocationsEditor.this.myPanel.add(view.getComponent(), "Center");
            }

            public void onCancel() {
                Messages.showErrorDialog((Project)project, (String)this.myErrorMessage, (String)AllocationsEditor.this.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/allocations/AllocationsEditor$1", "run"));
            }
        };
        ApplicationManager.getApplication().invokeLater(() -> ((Task.Modal)parseTask).queue());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AllocationsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("AllocationsView" == null) {
            AllocationsEditor.$$$reportNull$$$0(3);
        }
        return "AllocationsView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            AllocationsEditor.$$$reportNull$$$0(4);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            AllocationsEditor.$$$reportNull$$$0(5);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            AllocationsEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            AllocationsEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            AllocationsEditor.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            AllocationsEditor.$$$reportNull$$$0(9);
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            AllocationsEditor.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/allocations/AllocationsEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

