/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubmitCrashReportTask
extends Task.Backgroundable {
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final Throwable myThrowable;
    private final Map<String, String> myParams;

    public SubmitCrashReportTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable Throwable throwable, @NotNull Map<String, String> params, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
        if (title == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(0);
        }
        if (params == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(2);
        }
        if (errorCallback == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(3);
        }
        super(project, title, canBeCancelled);
        this.myThrowable = throwable;
        this.myParams = params;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(4);
        }
        indicator.setIndeterminate(true);
        CrashReport report = CrashReport.Builder.createForException(this.myThrowable).addProductData(this.getProductData()).build();
        CompletableFuture<String> future = CrashReporter.getInstance().submit(report, true);
        try {
            String token = future.get(20L, TimeUnit.SECONDS);
            this.myCallback.consume((Object)token);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }

    @NotNull
    private Map<String, String> getProductData() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.myParams.forEach((k, v) -> builder.put(k, (Object)StringUtil.notNullize((String)v)));
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            SubmitCrashReportTask.$$$reportNull$$$0(5);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

