/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResolveHelper {
    @Nullable
    public static PsiAnnotation getAnnotationForLocal(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            AndroidResolveHelper.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AndroidResolveHelper.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiVariable variable = facade.getResolveHelper().resolveReferencedVariable(name, context);
        if (variable != null) {
            return AndroidResolveHelper.getAnnotationForVariable(variable, 0);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation getAnnotationForVariable(@NotNull PsiVariable variable, int depth) {
        PsiReferenceExpression reference;
        PsiAnnotation annotation;
        PsiMethodCallExpression callExpression;
        PsiElement resolved;
        PsiAnnotation annotation2;
        if (variable == null) {
            AndroidResolveHelper.$$$reportNull$$$0(2);
        }
        if (depth > 10) {
            return null;
        }
        if ((variable instanceof PsiParameter || variable instanceof PsiLocalVariable) && (annotation2 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)variable)) != null) {
            return annotation2;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (initializer instanceof PsiMethodCallExpression ? (resolved = (callExpression = (PsiMethodCallExpression)initializer).getMethodExpression().resolve()) instanceof PsiMethod && (annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)resolved))) != null : initializer instanceof PsiReferenceExpression && ((resolved = (reference = (PsiReferenceExpression)initializer).resolve()) instanceof PsiField ? (annotation = AndroidResolveHelper.getAnnotationForField((PsiField)resolved)) != null : resolved instanceof PsiVariable && (annotation = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)resolved, depth + 1)) != null))) {
            return annotation;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class, (boolean)true);
        if (method == null) {
            return null;
        }
        Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)method, PsiAssignmentExpression.class);
        for (PsiAssignmentExpression assignment : assignments) {
            PsiReferenceExpression ref;
            PsiAnnotation annotation3;
            PsiMethodCallExpression callExpression2;
            PsiElement r;
            PsiExpression rhs;
            PsiReferenceExpression reference2;
            PsiElement resolved2;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression) || (resolved2 = (reference2 = (PsiReferenceExpression)lhs).resolve()) != variable || !((rhs = assignment.getRExpression()) instanceof PsiMethodCallExpression ? (r = (callExpression2 = (PsiMethodCallExpression)rhs).getMethodExpression().resolve()) instanceof PsiMethod && (annotation3 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)r))) != null : rhs instanceof PsiReferenceExpression && ((r = (ref = (PsiReferenceExpression)rhs).resolve()) instanceof PsiField ? (annotation3 = AndroidResolveHelper.getAnnotationForField((PsiField)r)) != null : r instanceof PsiVariable && (annotation3 = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)r, depth + 1)) != null))) continue;
            return annotation3;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAnnotationForField(@NotNull PsiElement context, @NotNull String className, @NotNull String fieldName) {
        if (context == null) {
            AndroidResolveHelper.$$$reportNull$$$0(3);
        }
        if (className == null) {
            AndroidResolveHelper.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            AndroidResolveHelper.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, AndroidResolveHelper.getSearchScope(context));
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(fieldName, true);
        if (field != null) {
            return AndroidResolveHelper.getAnnotationForField(field);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation getAnnotationForField(PsiField field) {
        PsiMethod getter;
        PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)field);
        if (annotation == null && (getter = PropertyUtilBase.findGetterForField((PsiField)field)) != null) {
            return AndroidResolveHelper.getAnnotation((PsiModifierListOwner)getter);
        }
        return annotation;
    }

    @NotNull
    private static GlobalSearchScope getSearchScope(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            AndroidResolveHelper.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
            GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(false);
            if (globalSearchScope == null) {
                AndroidResolveHelper.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)context.getProject());
        if (globalSearchScope == null) {
            AndroidResolveHelper.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Nullable
    private static PsiAnnotation getAnnotation(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return null;
        }
        Project project = owner.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope searchScope = AndroidResolveHelper.getSearchScope((PsiElement)owner);
        for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations(owner)) {
            String qualifiedName = a.getQualifiedName();
            if (qualifiedName == null || qualifiedName.startsWith("java")) continue;
            if (qualifiedName.endsWith("Res") || qualifiedName.equals("android.support.annotation.ColorInt") || qualifiedName.equals("android.support.annotation.Px") || qualifiedName.equals("android.support.annotation.IntDef")) {
                return a;
            }
            PsiClass annotationClass = psiFacade.findClass(qualifiedName, searchScope);
            PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static IntDefResolution resolveIntDef(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AndroidResolveHelper.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiAnnotationMemberValue intValues = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue[] allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
        HashMap valuesMap = Maps.newHashMap();
        for (PsiAnnotationMemberValue value : allowedValues) {
            Object v;
            if (!(value instanceof PsiReference)) {
                return IntDefResolution.createError();
            }
            PsiElement resolved = ((PsiReference)value).resolve();
            if (!(resolved instanceof PsiNamedElement)) {
                return IntDefResolution.createError();
            }
            Key key = Key.findKeyByName((String)"VALUE");
            Integer constantValue = null;
            if (key != null && (v = value.getUserData(key)) instanceof Integer) {
                constantValue = (Integer)v;
            }
            if (constantValue == null && resolved instanceof PsiField && (v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiField)resolved).getInitializer(), null, (boolean)false)) instanceof Integer) {
                constantValue = (Integer)v;
            }
            if (constantValue == null) {
                return IntDefResolution.createError();
            }
            valuesMap.put(constantValue, ((PsiNamedElement)resolved).getName());
        }
        PsiAnnotationMemberValue orValue = annotation.findAttributeValue("flag");
        boolean canBeOred = orValue instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue());
        return new IntDefResolution(canBeOred, valuesMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/debug/AndroidResolveHelper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/debug/AndroidResolveHelper";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationForLocal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationForVariable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationForField";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveIntDef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntDefResolution {
        @Nullable
        public final Map<Integer, String> valuesMap;
        public final boolean canBeOred;

        public IntDefResolution(boolean canBeOred, @Nullable Map<Integer, String> valuesMap) {
            this.canBeOred = canBeOred;
            this.valuesMap = valuesMap;
        }

        public static IntDefResolution createError() {
            return new IntDefResolution(false, null);
        }
    }

    public static class ResolveResult {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public ResolveResult(@NotNull String label, @Nullable Icon icon) {
            if (label == null) {
                ResolveResult.$$$reportNull$$$0(0);
            }
            this.label = label;
            this.icon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/debug/AndroidResolveHelper$ResolveResult", "<init>"));
        }
    }
}

