/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.adtui.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.hprof.HprofCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DumpHprofAction
extends AbstractClientAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private EventData myEvents;
    private boolean isCollectingHprofDump;

    public DumpHprofAction(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull EventData events) {
        if (project == null) {
            DumpHprofAction.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            DumpHprofAction.$$$reportNull$$$0(1);
        }
        if (events == null) {
            DumpHprofAction.$$$reportNull$$$0(2);
        }
        super(deviceContext, AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]), AndroidBundle.message("android.ddms.actions.dump.hprof.description", new Object[0]), AndroidIcons.Ddms.DumpHprof);
        this.myProject = project;
        this.myEvents = events;
    }

    @Override
    protected void performAction(@NotNull Client c) {
        if (c == null) {
            DumpHprofAction.$$$reportNull$$$0(3);
        }
        this.isCollectingHprofDump = true;
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new HprofRequest(c, this.myEvents));
    }

    @Override
    protected boolean canPerformAction() {
        return !this.isCollectingHprofDump;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/hprof/DumpHprofAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HprofRequest
    implements Runnable,
    AndroidDebugBridge.IClientChangeListener {
        private final Client myClient;
        private CountDownLatch myResponse;
        private final EventData myEvents;
        private EventData.Event myEvent;

        public HprofRequest(Client client, EventData events) {
            this.myClient = client;
            this.myEvents = events;
            this.myResponse = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            try {
                this.myClient.dumpHprof();
                EventData eventData = this.myEvents;
                synchronized (eventData) {
                    this.myEvent = this.myEvents.start(System.currentTimeMillis(), 1);
                }
                try {
                    this.myResponse.await(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                eventData = this.myEvents;
                synchronized (eventData) {
                    if (this.myEvent != null) {
                        this.myEvent.stop(System.currentTimeMillis());
                    }
                }
            }
            finally {
                DumpHprofAction.this.isCollectingHprofDump = false;
                AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            }
        }

        public void clientChanged(final Client client, int changeMask) {
            if (changeMask == 4096 && client == this.myClient) {
                assert (!ApplicationManager.getApplication().isDispatchThread());
                final ClientData.HprofData data = client.getClientData().getHprofData();
                if (data != null) {
                    switch (data.type) {
                        case FILE: {
                            Messages.showErrorDialog((String)AndroidBundle.message("android.ddms.actions.dump.hprof.error.unsupported", new Object[0]), (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
                            break;
                        }
                        case DATA: {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        final CaptureService service = CaptureService.getInstance(DumpHprofAction.this.myProject);
                                        String name = service.getSuggestedName(client);
                                        CaptureHandle handle = service.startCaptureFile(HprofCaptureType.class, name, true);
                                        service.appendDataCopy(handle, data.data);
                                        service.finalizeCaptureFileAsynchronous(handle, new FutureCallback<Capture>(){

                                            public void onSuccess(Capture result) {
                                                service.notifyCaptureReady(result);
                                            }

                                            public void onFailure(Throwable t) {
                                                Messages.showErrorDialog((String)"Error writing Hprof data", (String)"Dump Java Heap");
                                            }
                                        }, EdtExecutor.INSTANCE);
                                    }
                                    catch (IOException e) {
                                        Messages.showErrorDialog((String)"Error create Hprof file", (String)"Dump Java Heap");
                                    }
                                }
                            });
                        }
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((String)"Error obtaining Hprof data", (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
                        }
                    });
                }
                this.myResponse.countDown();
            }
        }
    }
}

