/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.hierarchyview.HierarchyViewCaptureTask;
import com.android.tools.idea.editors.hierarchyview.WindowPickerDialog;
import com.android.tools.idea.editors.hierarchyview.model.ClientWindow;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewAction
extends AbstractClientAction {
    private final Project myProject;

    public HierarchyViewAction(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            HierarchyViewAction.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            HierarchyViewAction.$$$reportNull$$$0(1);
        }
        super(deviceContext, AndroidBundle.message("android.ddms.actions.hierarchyview", new Object[0]), AndroidBundle.message("android.ddms.actions.hierarchyview.description", new Object[0]), AndroidIcons.Ddms.HierarchyView);
        this.myProject = project;
    }

    @Override
    protected void performAction(@NotNull Client client) {
        if (client == null) {
            HierarchyViewAction.$$$reportNull$$$0(2);
        }
        new GetClientWindowsTask(this.myProject, client).queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/HierarchyViewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class GetClientWindowsTask
    extends Task.Backgroundable {
        private final Client myClient;
        private List<ClientWindow> myWindows;

        public GetClientWindowsTask(@Nullable Project project, @NotNull Client client) {
            if (client == null) {
                GetClientWindowsTask.$$$reportNull$$$0(0);
            }
            super(project, "Obtaining Windows");
            this.myClient = client;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GetClientWindowsTask.$$$reportNull$$$0(1);
            }
            indicator.setIndeterminate(true);
            this.myWindows = ClientWindow.getAll(this.myClient, 5L, TimeUnit.SECONDS);
        }

        public void onSuccess() {
            ClientWindow window;
            String title = "Capture View Hierarchy";
            if (this.myWindows == null) {
                Messages.showErrorDialog((String)("Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName()), (String)title);
                return;
            }
            if (this.myWindows.isEmpty()) {
                Messages.showErrorDialog((String)("No active windows displayed by " + this.myClient.getClientData().getPackageName()), (String)title);
                return;
            }
            if (this.myWindows.size() == 1) {
                window = this.myWindows.get(0);
            } else {
                WindowPickerDialog pickerDialog = new WindowPickerDialog(this.myProject, this.myClient, this.myWindows);
                if (!pickerDialog.showAndGet()) {
                    return;
                }
                window = pickerDialog.getSelectedWindow();
                if (window == null) {
                    return;
                }
            }
            HierarchyViewCaptureTask captureTask = new HierarchyViewCaptureTask(this.myProject, this.myClient, window);
            captureTask.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/actions/HierarchyViewAction$GetClientWindowsTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

