/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeSelectionPanel
implements TreeSelectionListener,
ListSelectionListener,
Disposable {
    private static final String DEVICE_LIGHT_PREFIX = "android:Theme.DeviceDefault.Light";
    private static final String DEVICE_PREFIX = "android:Theme.DeviceDefault";
    private static final String HOLO_LIGHT_PREFIX = "android:Theme.Holo.Light";
    private static final String HOLO_PREFIX = "android:Theme.Holo";
    private static final String MATERIAL_LIGHT_PREFIX = "android:Theme.Material.Light";
    private static final String MATERIAL_PREFIX = "android:Theme.Material";
    private static final String LIGHT_PREFIX = "android:Theme.Light";
    private static final String ANDROID_THEME = "android:Theme";
    private static final String ANDROID_THEME_PREFIX = "android:Theme.";
    private static final String PROJECT_THEME = "Theme";
    private static final String PROJECT_THEME_PREFIX = "Theme.";
    private static final String DIALOG_SUFFIX = ".Dialog";
    private static final String DIALOG_PART = ".Dialog.";
    private static final SimpleTextAttributes SEARCH_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(null, JBColor.MAGENTA, null, 1);
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final ThemeSelectionDialog myDialog;
    @NotNull
    private JBList myThemeList;
    @NotNull
    private Tree myCategoryTree;
    @NotNull
    private JPanel myContentPanel;
    @NotNull
    private ThemeFilterComponent myFilter;
    @Nullable
    private List<String> myFrameworkThemes;
    @Nullable
    private List<String> myProjectThemes;
    @Nullable
    private List<String> myLibraryThemes;
    @Nullable
    private static Deque<String> ourRecent;
    @Nullable
    private ThemeCategory myCategory;
    @NotNull
    private Map<ThemeCategory, List<String>> myThemeMap;
    @NotNull
    private ThemeResolver myThemeResolver;
    @NotNull
    private Set<String> myExcludedThemes;
    private boolean myIgnore;
    private ThemeChangedListener myThemeChangedListener;

    public ThemeSelectionPanel(@NotNull ThemeSelectionDialog dialog, @NotNull Configuration configuration, @NotNull Set<String> excludedThemes) {
        if (dialog == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(1);
        }
        if (excludedThemes == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(2);
        }
        this.myCategory = ThemeCategory.ALL;
        this.$$$setupUI$$$();
        this.myThemeMap = Maps.newEnumMap(ThemeCategory.class);
        this.myDialog = dialog;
        this.myConfiguration = configuration;
        this.myExcludedThemes = excludedThemes;
        this.myThemeResolver = new ThemeResolver(configuration);
        String currentTheme = configuration.getTheme();
        if (currentTheme != null) {
            currentTheme = ResolutionUtils.getQualifiedNameFromResourceUrl(currentTheme);
        }
        ThemeSelectionPanel.touchTheme(currentTheme, this.myExcludedThemes);
        this.myCategoryTree.setModel((TreeModel)new CategoryModel());
        this.myCategoryTree.setRootVisible(false);
        this.myCategoryTree.getSelectionModel().setSelectionMode(1);
        this.myCategoryTree.addTreeSelectionListener((TreeSelectionListener)this);
        this.setInitialSelection(currentTheme);
        this.myThemeList.addListSelectionListener((ListSelectionListener)this);
        this.myThemeList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                int matchIndex;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(AndroidIcons.Themes);
                String style = (String)value;
                String filter = ThemeSelectionPanel.this.myFilter.getFilter();
                if (style.startsWith(ThemeSelectionPanel.ANDROID_THEME_PREFIX)) {
                    style = style.substring(ThemeSelectionPanel.ANDROID_THEME_PREFIX.length());
                } else if (style.startsWith(ThemeSelectionPanel.PROJECT_THEME_PREFIX)) {
                    style = style.substring(ThemeSelectionPanel.PROJECT_THEME_PREFIX.length());
                } else if (style.startsWith("@style/")) {
                    style = style.substring("@style/".length());
                } else if (style.equals(ThemeSelectionPanel.ANDROID_THEME) || style.equals(ThemeSelectionPanel.PROJECT_THEME)) {
                    style = ThemeSelectionPanel.PROJECT_THEME;
                }
                if (!filter.isEmpty() && (matchIndex = StringUtil.indexOfIgnoreCase((String)style, (String)filter, (int)(index + 1))) != -1) {
                    if (matchIndex > 0) {
                        this.append(style.substring(0, matchIndex), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    int matchEnd = matchIndex + filter.length();
                    this.append(style.substring(matchIndex, matchEnd), SEARCH_HIGHLIGHT_ATTRIBUTES);
                    if (matchEnd < style.length()) {
                        this.append(style.substring(matchEnd), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    return;
                }
                int lastDot = style.lastIndexOf(46);
                if (lastDot > 0) {
                    this.append(style.substring(0, lastDot + 1), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.append(style.substring(lastDot + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(style, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/configurations/ThemeSelectionPanel$1", "customizeCellRenderer"));
            }
        });
    }

    public void installDoubleClickListener(@NotNull DoubleClickListener listener) {
        if (listener == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(3);
        }
        listener.installOn((Component)this.myThemeList);
    }

    public void setThemeChangedListener(@NotNull ThemeChangedListener themeChangedListener) {
        if (themeChangedListener == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(4);
        }
        this.myThemeChangedListener = themeChangedListener;
    }

    private void setInitialSelection(@Nullable String currentTheme) {
        if (currentTheme == null) {
            this.myCategoryTree.setSelectionRow(0);
            return;
        }
        if (currentTheme.startsWith(HOLO_LIGHT_PREFIX)) {
            this.selectCategory(ThemeCategory.HOLO_LIGHT, true);
        } else if (currentTheme.startsWith(HOLO_PREFIX)) {
            this.selectCategory(ThemeCategory.HOLO, true);
        }
        if (currentTheme.startsWith(MATERIAL_LIGHT_PREFIX)) {
            this.selectCategory(ThemeCategory.MATERIAL_LIGHT, true);
        } else if (currentTheme.startsWith(MATERIAL_PREFIX)) {
            this.selectCategory(ThemeCategory.MATERIAL, true);
        } else if (currentTheme.startsWith(DEVICE_PREFIX)) {
            this.selectCategory(ThemeCategory.DEVICE, true);
        } else if (currentTheme.startsWith("@style/")) {
            this.selectCategory(ThemeCategory.PROJECT, true);
        } else {
            this.selectCategory(ThemeCategory.ALL, true);
        }
        this.updateThemeList();
        this.myThemeList.setSelectedValue((Object)currentTheme, true);
    }

    private void selectCategory(ThemeCategory category, boolean updateList) {
        try {
            this.myIgnore = true;
            this.myCategoryTree.setSelectionPath(new TreePath((Object[])new ThemeCategory[]{ThemeCategory.ROOT, category}));
            this.myCategory = category;
        }
        finally {
            this.myIgnore = false;
        }
        if (updateList) {
            this.updateThemeList();
        }
    }

    @NotNull
    public JPanel getContentPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private List<String> getThemes(@Nullable ThemeCategory category) {
        if (category == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ThemeSelectionPanel.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> themes = this.myThemeMap.get((Object)category);
        if (themes != null) {
            List<String> list = themes;
            if (list == null) {
                ThemeSelectionPanel.$$$reportNull$$$0(7);
            }
            return list;
        }
        themes = new ArrayList<String>(50);
        switch (category) {
            case RECENT: {
                if (ourRecent == null) break;
                for (String theme : ourRecent) {
                    themes.add(theme);
                }
                break;
            }
            case HOLO: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(HOLO_PREFIX) || theme.startsWith(HOLO_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case HOLO_LIGHT: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(HOLO_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MATERIAL: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(MATERIAL_PREFIX) || theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MATERIAL_LIGHT: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case PROJECT: {
                for (String theme : this.getProjectThemes()) {
                    themes.add(theme);
                }
                break;
            }
            case CLASSIC: {
                for (String theme : this.getFrameworkThemes()) {
                    if (theme.startsWith(HOLO_PREFIX) || theme.startsWith(DEVICE_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case CLASSIC_LIGHT: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case LIGHT: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(HOLO_LIGHT_PREFIX) && !theme.startsWith(LIGHT_PREFIX) && !theme.startsWith(DEVICE_LIGHT_PREFIX) && !theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case DEVICE: {
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.startsWith(DEVICE_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case DIALOGS: {
                for (String theme : this.getProjectThemes()) {
                    if (!theme.endsWith(DIALOG_SUFFIX) && !theme.contains(DIALOG_PART)) continue;
                    themes.add(theme);
                }
                for (String theme : this.getFrameworkThemes()) {
                    if (!theme.endsWith(DIALOG_SUFFIX) && !theme.contains(DIALOG_PART)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MANIFEST: {
                MergedManifest manifest = MergedManifest.get(this.myConfiguration.getModule());
                Map<String, MergedManifest.ActivityAttributes> activityAttributesMap = manifest.getActivityAttributesMap();
                String manifestTheme = manifest.getManifestTheme();
                HashSet<String> allThemes = new HashSet<String>();
                if (manifestTheme != null) {
                    allThemes.add(manifestTheme);
                }
                for (MergedManifest.ActivityAttributes info : activityAttributesMap.values()) {
                    if (info.getTheme() == null) continue;
                    allThemes.add(info.getTheme());
                }
                ArrayList sorted = new ArrayList(allThemes);
                Collections.sort(sorted);
                for (String theme : sorted) {
                    themes.add(ResolutionUtils.getQualifiedNameFromResourceUrl(theme));
                }
                break;
            }
            case ALL: {
                for (String theme : this.getProjectThemes()) {
                    themes.add(theme);
                }
                for (String theme : this.getFrameworkThemes()) {
                    themes.add(theme);
                }
                for (String theme : this.getLibraryThemes()) {
                    themes.add(theme);
                }
                break;
            }
            default: {
                assert (false) : category;
                break;
            }
        }
        this.myThemeMap.put(category, themes);
        List<String> list = themes;
        if (list == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void updateThemeList() {
        if (this.myCategory == null) {
            return;
        }
        String selected = (String)this.myThemeList.getSelectedValue();
        SortedListModel model = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
        String filter = this.myFilter.getFilter();
        List<String> themes = this.getThemes(this.myCategory);
        for (String theme : themes) {
            if (!ThemeSelectionPanel.matchesFilter(theme, filter)) continue;
            model.add((Object)theme);
        }
        this.myThemeList.setModel((ListModel)model);
        if (selected != null) {
            this.myThemeList.setSelectedValue((Object)selected, true);
        } else if (model.getSize() > 0) {
            this.myThemeList.setSelectedIndex(0);
        }
    }

    private static boolean matchesFilter(String theme, String filter) {
        int index = theme.lastIndexOf(47);
        return filter.isEmpty() || StringUtil.indexOfIgnoreCase((String)theme, (String)filter, (int)(index + 1)) != -1;
    }

    private List<String> getFrameworkThemes() {
        if (this.myFrameworkThemes == null) {
            this.myFrameworkThemes = ThemeSelectionPanel.getFilteredSortedNames(ThemeSelectionPanel.getPublicThemes(this.myThemeResolver.getFrameworkThemes()), this.myExcludedThemes);
        }
        return this.myFrameworkThemes;
    }

    private List<String> getProjectThemes() {
        if (this.myProjectThemes == null) {
            this.myProjectThemes = ThemeSelectionPanel.getFilteredSortedNames(ThemeSelectionPanel.getPublicThemes(this.myThemeResolver.getLocalThemes()), this.myExcludedThemes);
        }
        return this.myProjectThemes;
    }

    private List<String> getLibraryThemes() {
        if (this.myLibraryThemes == null) {
            this.myLibraryThemes = ThemeSelectionPanel.getFilteredPrefixesSortedNames(ThemeSelectionPanel.getPublicThemes(this.myThemeResolver.getExternalLibraryThemes()), this.myExcludedThemes, Collections.singleton("Base."));
        }
        return this.myLibraryThemes;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String themeName;
        if (this.myIgnore) {
            return;
        }
        if (this.myThemeChangedListener != null && (themeName = this.getTheme()) != null) {
            this.myThemeChangedListener.themeChanged(themeName);
        }
        this.myDialog.checkValidation();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.myIgnore) {
            return;
        }
        TreePath path = treeSelectionEvent.getPath();
        if (path == null) {
            return;
        }
        this.myCategory = (ThemeCategory)((Object)path.getLastPathComponent());
        this.updateThemeList();
        if (this.myThemeList.getModel().getSize() > 0) {
            this.myThemeList.setSelectedIndex(0);
        }
    }

    @Nullable
    public String getTheme() {
        String selected = (String)this.myThemeList.getSelectedValue();
        ThemeSelectionPanel.touchTheme(selected, this.myExcludedThemes);
        return selected;
    }

    private static void touchTheme(@Nullable String selected, Set<String> excludedThemes) {
        if (!(selected == null || ourRecent != null && ourRecent.contains(selected))) {
            if (ourRecent == null) {
                ourRecent = new LinkedList<String>();
            }
            if (!excludedThemes.contains(selected)) {
                ourRecent.addFirst(selected);
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCategoryTree;
    }

    public void dispose() {
        this.myFilter.dispose();
    }

    private static List<String> getFilteredSortedNames(Collection<ConfiguredThemeEditorStyle> themesRaw, Set<String> excludedThemes) {
        return ThemeSelectionPanel.getFilteredPrefixesSortedNames(themesRaw, excludedThemes, Collections.emptySet());
    }

    private static List<String> getFilteredPrefixesSortedNames(Collection<ConfiguredThemeEditorStyle> themesRaw, Set<String> excludedThemes, Set<String> excludedPrefixes) {
        ArrayList<String> themes = new ArrayList<String>(themesRaw.size());
        for (ConfiguredThemeEditorStyle theme : themesRaw) {
            String qualifiedName = theme.getQualifiedName();
            if (excludedThemes.contains(qualifiedName)) continue;
            boolean startWithPrefix = false;
            String themeName = theme.getName();
            for (String prefix : excludedPrefixes) {
                if (!themeName.startsWith(prefix)) continue;
                startWithPrefix = true;
                break;
            }
            if (startWithPrefix) continue;
            themes.add(qualifiedName);
        }
        Collections.sort(themes);
        return themes;
    }

    private static Collection<ConfiguredThemeEditorStyle> getPublicThemes(Collection<ConfiguredThemeEditorStyle> themes) {
        HashSet<ConfiguredThemeEditorStyle> publicThemes = new HashSet<ConfiguredThemeEditorStyle>();
        for (ConfiguredThemeEditorStyle theme : themes) {
            if (!theme.isPublic()) continue;
            publicThemes.add(theme);
        }
        return publicThemes;
    }

    public void focus() {
        Project project = this.myConfiguration.getModule().getProject();
        final IdeFocusManager focusManager = project.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)project);
        focusManager.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                focusManager.requestFocus((Component)ThemeSelectionPanel.this.myThemeList, true);
            }
        });
    }

    private static boolean haveMatches(String filter, List<String> themes) {
        for (String theme : themes) {
            if (!ThemeSelectionPanel.matchesFilter(theme, filter)) continue;
            return true;
        }
        return false;
    }

    private boolean haveAnyMatches(String filter) {
        return ThemeSelectionPanel.haveMatches(filter, this.getFrameworkThemes()) || ThemeSelectionPanel.haveMatches(filter, this.getProjectThemes());
    }

    private void createUIComponents() {
        this.myFilter = new ThemeFilterComponent("ANDROID_THEME_HISTORY", 10, true);
        this.myFilter.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    ThemeSelectionPanel.this.myThemeList.dispatchEvent((AWTEvent)e);
                    e.consume();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedThemes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeChangedListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ThemeSelectionPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ThemeSelectionPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installDoubleClickListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setThemeChangedListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        Tree tree;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCategoryTree = tree = new Tree();
        jPanel.add((Component)tree, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        this.myThemeList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ThemeFilterComponent themeFilterComponent = this.myFilter;
        jPanel.add((Component)((Object)themeFilterComponent), new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    public static interface ThemeChangedListener {
        public void themeChanged(@NotNull String var1);
    }

    private class ThemeFilterComponent
    extends FilterComponent {
        private ThemeFilterComponent(String propertyName, int historySize, boolean onTheFlyUpdate) {
            super(propertyName, historySize, onTheFlyUpdate);
        }

        public void filter() {
            String filter = this.getFilter();
            assert (filter != null);
            if (ThemeSelectionPanel.this.myCategory != ThemeCategory.ALL && !ThemeSelectionPanel.haveMatches(filter, ThemeSelectionPanel.this.getThemes(ThemeSelectionPanel.this.myCategory)) && ThemeSelectionPanel.this.haveAnyMatches(filter)) {
                ThemeSelectionPanel.this.selectCategory(ThemeCategory.ALL, false);
            }
            ThemeSelectionPanel.this.updateThemeList();
        }

        protected void onEscape(KeyEvent e) {
            ThemeSelectionPanel.this.focus();
            e.consume();
        }
    }

    private static enum ThemeCategory {
        ROOT(""),
        RECENT("Recent"),
        MANIFEST("Manifest Themes"),
        PROJECT("Project Themes"),
        MATERIAL_LIGHT("Material Light"),
        MATERIAL("Material Dark"),
        HOLO_LIGHT("Holo Light"),
        HOLO("Holo Dark"),
        CLASSIC("Classic"),
        CLASSIC_LIGHT("Classic Light"),
        DEVICE("Device Default"),
        DIALOGS("Dialogs"),
        LIGHT("Light"),
        ALL("All");

        private final String myName;

        private ThemeCategory(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }

    private class CategoryModel
    implements TreeModel {
        @NotNull
        private final Map<ThemeCategory, List<ThemeCategory>> myLabels = Maps.newHashMap();

        CategoryModel() {
            AndroidModuleInfo info;
            ArrayList topLevel = Lists.newArrayList();
            if (ourRecent != null) {
                topLevel.add(ThemeCategory.RECENT);
            }
            if (!ThemeSelectionPanel.this.getThemes(ThemeCategory.MANIFEST).isEmpty()) {
                topLevel.add(ThemeCategory.MANIFEST);
            }
            if (!ThemeSelectionPanel.this.getThemes(ThemeCategory.PROJECT).isEmpty()) {
                topLevel.add(ThemeCategory.PROJECT);
            }
            if ((info = AndroidModuleInfo.get(ThemeSelectionPanel.this.myConfiguration.getConfigurationManager().getModule())) != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() >= 21) {
                topLevel.add(ThemeCategory.MATERIAL);
                topLevel.add(ThemeCategory.MATERIAL_LIGHT);
            }
            topLevel.add(ThemeCategory.HOLO);
            topLevel.add(ThemeCategory.HOLO_LIGHT);
            if (info == null || info.getMinSdkVersion().getFeatureLevel() <= 14) {
                topLevel.add(ThemeCategory.CLASSIC);
                topLevel.add(ThemeCategory.CLASSIC_LIGHT);
            }
            topLevel.add(ThemeCategory.DEVICE);
            topLevel.add(ThemeCategory.DIALOGS);
            topLevel.add(ThemeCategory.LIGHT);
            topLevel.add(ThemeCategory.ALL);
            this.myLabels.put(ThemeCategory.ROOT, topLevel);
        }

        @Override
        public Object getRoot() {
            return ThemeCategory.ROOT;
        }

        @Override
        public Object getChild(Object parent, int index) {
            assert (parent instanceof ThemeCategory);
            return this.myLabels.get(parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            assert (parent instanceof ThemeCategory);
            List<ThemeCategory> list = this.myLabels.get(parent);
            return list == null ? 0 : list.size();
        }

        @Override
        public boolean isLeaf(Object node) {
            assert (node instanceof ThemeCategory);
            return this.myLabels.get(node) == null;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            assert (parent instanceof ThemeCategory);
            assert (child instanceof ThemeCategory);
            List<ThemeCategory> list = this.myLabels.get(parent);
            return list == null ? -1 : list.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

