/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.FlatAction;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends FlatAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            ThemeMenuAction.$$$reportNull$$$0(0);
        }
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Theme in Editor");
        presentation.setIcon(AndroidIcons.NeleIcons.Theme);
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            if ("" == null) {
                ThemeMenuAction.$$$reportNull$$$0(1);
            }
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            String string = theme.substring(index + 1);
            if (string == null) {
                ThemeMenuAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = theme;
        if (string == null) {
            ThemeMenuAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void actionPerformed(AnActionEvent e) {
        String theme;
        ThemeSelectionDialog dialog;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
            configuration.setTheme(theme);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

