/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class DeleteAvdAction
extends AvdUiAction {
    public DeleteAvdAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Delete", "Delete this AVD", AllIcons.Actions.Delete);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        AvdInfo info = this.getAvdInfo();
        if (info == null) {
            return;
        }
        if (connection.isAvdRunning(info)) {
            Messages.showErrorDialog((Component)this.myAvdInfoProvider.getComponent(), (String)"The selected AVD is currently running in the Emulator. Please exit the emulator instance and try deleting again.", (String)"Cannot Delete A Running AVD");
            return;
        }
        int result = Messages.showYesNoDialog((Component)this.myAvdInfoProvider.getComponent(), (String)("Do you really want to delete AVD " + info.getName() + "?"), (String)"Confirm Deletion", (Icon)AllIcons.General.QuestionDialog);
        if (result == 0) {
            if (!connection.deleteAvd(info)) {
                Messages.showErrorDialog((Component)this.myAvdInfoProvider.getComponent(), (String)"An error occurred while deleting the AVD. See idea.log for details.", (String)"Error Deleting AVD");
            }
            this.refreshAvds();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

