/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.SystemImageList;
import com.android.tools.idea.avdmanager.SystemImageListModel;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImagePanel
extends JPanel
implements SystemImageList.SystemImageSelectionListener,
SystemImageListModel.StatusIndicator,
Disposable {
    private final List<Consumer<SystemImageDescription>> mySystemImageListeners;
    private JPanel myPanel;
    private SystemImageList myRecommendedImageList;
    private SystemImageList myX86ImageList;
    private SystemImageList myOtherImageList;
    private SystemImagePreview mySystemImagePreview;
    private JBTabbedPane myTabPane;
    private JBLabel myStatusLabel;
    private JButton myRefreshButton;
    private AsyncProcessIcon myAsyncIcon;
    private SystemImageListModel myListModel;
    @Nullable
    private Device myDevice;
    @Nullable
    private SystemImageDescription mySystemImage;

    public void setDevice(@Nullable Device device) {
        this.myDevice = device;
        this.myListModel.refreshImages(false);
    }

    public ChooseSystemImagePanel(@Nullable Project project, @Nullable Device initialDevice, @Nullable SystemImageDescription initialSystemImage) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.mySystemImageListeners = Lists.newArrayListWithExpectedSize((int)1);
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myPanel);
        this.mySystemImage = initialSystemImage;
        this.myDevice = initialDevice;
        this.myListModel = new SystemImageListModel(project, this);
        this.setupImageLists();
        this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSystemImagePanel.this.myListModel.refreshImages(true);
            }
        });
        this.myTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChooseSystemImagePanel.this.previewCurrentTab();
            }
        });
        this.myRecommendedImageList.addSelectionListener(this);
        this.myRecommendedImageList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.myListModel.refreshLocalImagesSynchronously();
        this.myListModel.refreshImages(false);
        this.setSelectedImage(this.mySystemImage);
        this.add(this.myPanel);
    }

    @NotNull
    private static SystemImageClassification getClassification(@NotNull SystemImageDescription image) {
        if (image == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(0);
        }
        SystemImageClassification systemImageClassification = ChooseSystemImagePanel.getClassificationFromParts(Abi.getEnum((String)image.getAbiType()), image.getVersion().getApiLevel(), image.getTag());
        if (systemImageClassification == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(1);
        }
        return systemImageClassification;
    }

    @NotNull
    static SystemImageClassification getClassificationFromParts(Abi abi, int apiLevel, IdDisplay tag) {
        boolean isAvdIntel;
        boolean bl = isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
        if (!isAvdIntel) {
            SystemImageClassification systemImageClassification = SystemImageClassification.OTHER;
            if (systemImageClassification == null) {
                ChooseSystemImagePanel.$$$reportNull$$$0(2);
            }
            return systemImageClassification;
        }
        if (apiLevel <= 21) {
            SystemImageClassification systemImageClassification = SystemImageClassification.X86;
            if (systemImageClassification == null) {
                ChooseSystemImagePanel.$$$reportNull$$$0(3);
            }
            return systemImageClassification;
        }
        if (abi == Abi.X86 && AvdWizardUtils.TAGS_WITH_GOOGLE_API.contains(tag)) {
            SystemImageClassification systemImageClassification = SystemImageClassification.RECOMMENDED;
            if (systemImageClassification == null) {
                ChooseSystemImagePanel.$$$reportNull$$$0(4);
            }
            return systemImageClassification;
        }
        SystemImageClassification systemImageClassification = SystemImageClassification.X86;
        if (systemImageClassification == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(5);
        }
        return systemImageClassification;
    }

    public static boolean systemImageMatchesDevice(@Nullable SystemImageDescription image, @Nullable Device device) {
        if (device == null || image == null) {
            return false;
        }
        String deviceTagId = device.getTagId();
        IdDisplay imageTag = image.getTag();
        if (deviceTagId == null || deviceTagId.equals(SystemImage.DEFAULT_TAG.getId())) {
            return imageTag.equals((Object)SystemImage.DEFAULT_TAG) || !imageTag.equals((Object)SystemImage.TV_TAG) && !imageTag.equals((Object)SystemImage.WEAR_TAG);
        }
        return deviceTagId.equals(imageTag.getId());
    }

    private void setupImageLists() {
        this.setupImageList(this.myRecommendedImageList);
        this.setupImageList(this.myX86ImageList);
        this.setupImageList(this.myOtherImageList);
        this.setImageListFilters();
    }

    private void setupImageList(@NotNull SystemImageList list) {
        if (list == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(6);
        }
        list.setModel(this.myListModel);
        list.addSelectionListener(this);
        list.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
    }

    private void setImageListFilters() {
        this.myRecommendedImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.RECOMMENDED));
        this.myX86ImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.X86));
        this.myOtherImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.OTHER));
    }

    @Override
    public void onSystemImageSelected(@Nullable SystemImageDescription systemImage) {
        this.mySystemImagePreview.setImage(systemImage);
        this.mySystemImage = systemImage != null && !systemImage.isRemote() ? systemImage : null;
        for (Consumer<SystemImageDescription> listener : this.mySystemImageListeners) {
            listener.consume((Object)this.mySystemImage);
        }
    }

    private void setSelectedImage(@Nullable SystemImageDescription systemImage) {
        if (systemImage != null) {
            SystemImageClassification classification = ChooseSystemImagePanel.getClassification(systemImage);
            switch (classification) {
                case RECOMMENDED: {
                    this.myRecommendedImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(0);
                    break;
                }
                case X86: {
                    this.myX86ImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.myOtherImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(2);
                }
            }
        }
    }

    @Override
    public void onRefreshStart(@NotNull String message) {
        if (message == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(7);
        }
        this.myStatusLabel.setText(message);
        this.myRefreshButton.setEnabled(false);
        this.myAsyncIcon.setVisible(true);
    }

    @Override
    public void onRefreshDone(@NotNull String message, boolean partlyDownloaded) {
        if (message == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(8);
        }
        this.myStatusLabel.setText(message);
        this.myRefreshButton.setEnabled(true);
        this.myAsyncIcon.setVisible(false);
        this.myRecommendedImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.myX86ImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.myOtherImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.previewCurrentTab();
    }

    private void previewCurrentTab() {
        switch (this.myTabPane.getSelectedIndex()) {
            case 0: {
                this.myRecommendedImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(true);
                break;
            }
            case 1: {
                this.myX86ImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(false);
                break;
            }
            default: {
                this.myOtherImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(false);
            }
        }
    }

    private void createUIComponents() {
        this.myAsyncIcon = new AsyncProcessIcon("refresh images");
        this.myRecommendedImageList = new SystemImageList();
        this.myX86ImageList = new SystemImageList();
        this.myOtherImageList = new SystemImageList();
        this.mySystemImagePreview = new SystemImagePreview(this);
    }

    public void addSystemImageListener(@NotNull Consumer<SystemImageDescription> onSystemImageSelected) {
        if (onSystemImageSelected == null) {
            ChooseSystemImagePanel.$$$reportNull$$$0(9);
        }
        this.mySystemImageListeners.add(onSystemImageSelected);
        onSystemImageSelected.consume((Object)this.mySystemImage);
    }

    public void dispose() {
        this.mySystemImageListeners.clear();
    }

    @Nullable
    public SystemImageDescription getSystemImage() {
        return this.mySystemImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/ChooseSystemImagePanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSystemImageSelected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/ChooseSystemImagePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassification";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassificationFromParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassification";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupImageList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onRefreshStart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onRefreshDone";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSystemImageListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        SystemImagePreview systemImagePreview = this.mySystemImagePreview;
        JComponent jComponent = systemImagePreview.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 2, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Recommended", null, jPanel2, null);
        SystemImageList systemImageList = this.myRecommendedImageList;
        jPanel2.add((Component)systemImageList, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("x86 Images", null, jPanel3, null);
        SystemImageList systemImageList2 = this.myX86ImageList;
        jPanel3.add((Component)systemImageList2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Other Images", null, jPanel4, null);
        SystemImageList systemImageList3 = this.myOtherImageList;
        jPanel4.add((Component)systemImageList3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(54, 10), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myRefreshButton = jButton = new JButton();
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/nele/preview.png")));
        jButton.setText("");
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStatusLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myAsyncIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ClassificationRowFilter
    extends RowFilter<ListTableModel<SystemImageDescription>, Integer> {
        private final SystemImageClassification myClassification;

        public ClassificationRowFilter(SystemImageClassification classification) {
            if (classification == null) {
                ClassificationRowFilter.$$$reportNull$$$0(0);
            }
            this.myClassification = classification;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ListTableModel<SystemImageDescription>, ? extends Integer> entry) {
            SystemImageDescription image = (SystemImageDescription)ChooseSystemImagePanel.this.myListModel.getRowValue(entry.getIdentifier());
            return ChooseSystemImagePanel.getClassification(image) == this.myClassification && ChooseSystemImagePanel.systemImageMatchesDevice(image, ChooseSystemImagePanel.this.myDevice) && this.versionSupported(image);
        }

        private boolean versionSupported(@NotNull SystemImageDescription image) {
            if (image == null) {
                ClassificationRowFilter.$$$reportNull$$$0(1);
            }
            return image.getVersion().getApiLevel() > 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classification";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/avdmanager/ChooseSystemImagePanel$ClassificationRowFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "versionSupported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum SystemImageClassification {
        RECOMMENDED,
        X86,
        OTHER;

    }
}

