/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.CloneDeviceAction;
import com.android.tools.idea.avdmanager.CreateDeviceAction;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.avdmanager.EditDeviceAction;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseDeviceDefinitionPanel
extends JPanel
implements DeviceUiAction.DeviceProvider,
Disposable {
    private final EditDeviceAction myEditDeviceAction;
    private final CreateDeviceAction myCreateDeviceAction;
    private final CloneDeviceAction myCloneDeviceAction;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JPanel myEditButtonContainer;
    private JButton myEditDeviceButton;
    private JPanel myPanel;
    private DeviceDefinitionList myDeviceDefinitionList;
    private List<Consumer<Device>> myDeviceListeners;

    public ChooseDeviceDefinitionPanel(@Nullable Device initialDevice) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myEditDeviceAction = new EditDeviceAction(this, "Edit Device...");
        this.myCreateDeviceAction = new CreateDeviceAction(this, "Create Device...");
        this.myCloneDeviceAction = new CloneDeviceAction(this, "Clone Device...");
        this.myDeviceListeners = Lists.newArrayListWithExpectedSize((int)1);
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myPanel);
        this.updateEditButton(initialDevice);
        this.myDeviceDefinitionList.addSelectionListener(selectedDevice -> {
            if (selectedDevice != null) {
                this.myDeviceDefinitionPreview.getDeviceData().updateValuesFromDevice(selectedDevice, null);
            } else {
                this.myDeviceDefinitionPreview.getDeviceData().name().set("DO_NOT_DISPLAY");
            }
            this.updateEditButton(selectedDevice);
            for (Consumer<Device> listener : this.myDeviceListeners) {
                listener.consume((Object)selectedDevice);
            }
        });
        this.myDeviceDefinitionList.addCategoryListener(this.myDeviceDefinitionPreview);
        this.myDeviceDefinitionList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.myEditButtonContainer.setBackground(JBColor.background());
        this.myEditDeviceButton.setBackground(JBColor.background());
        if (initialDevice != null) {
            this.myDeviceDefinitionList.setSelectedDevice(initialDevice);
        } else {
            this.myDeviceDefinitionList.selectDefaultDevice();
        }
        this.add(this.myPanel);
    }

    public void addDeviceListener(@NotNull Consumer<Device> onDeviceSelected) {
        if (onDeviceSelected == null) {
            ChooseDeviceDefinitionPanel.$$$reportNull$$$0(0);
        }
        this.myDeviceListeners.add(onDeviceSelected);
        onDeviceSelected.consume((Object)this.getDevice());
    }

    @Override
    @Nullable
    public Device getDevice() {
        return this.myDeviceDefinitionList.getDevice();
    }

    @Override
    public void setDevice(@Nullable Device device) {
        this.myDeviceDefinitionList.setSelectedDevice(device);
    }

    @Override
    public void selectDefaultDevice() {
        this.myDeviceDefinitionList.selectDefaultDevice();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myDeviceDefinitionList.getProject();
    }

    @Override
    public void refreshDevices() {
        this.myDeviceDefinitionList.refreshDevices();
    }

    private void updateEditButton(@Nullable Device selectedDevice) {
        this.myEditDeviceButton.setAction(null);
        DeviceUiAction action = selectedDevice == null ? this.myCreateDeviceAction : (DeviceManagerConnection.getDefaultDeviceManagerConnection().isUserDevice(selectedDevice) ? this.myEditDeviceAction : this.myCloneDeviceAction);
        this.myEditDeviceButton.setAction(action);
    }

    private void createUIComponents() {
        this.myDeviceDefinitionPreview = new DeviceDefinitionPreview(new AvdDeviceData());
    }

    public void dispose() {
        this.myDeviceListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDeviceSelected", "com/android/tools/idea/avdmanager/ChooseDeviceDefinitionPanel", "addDeviceListener"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DeviceDefinitionList deviceDefinitionList;
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        DeviceDefinitionPreview deviceDefinitionPreview = this.myDeviceDefinitionPreview;
        jPanel2.add((Component)deviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
        this.myEditButtonContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myEditDeviceButton = jButton = new JButton();
        jButton.setText("Edit Device");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDeviceDefinitionList = deviceDefinitionList = new DeviceDefinitionList();
        JComponent jComponent = deviceDefinitionList.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

