/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.run.EmulatorConnectionListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
    private static final AvdManagerConnection NULL_CONNECTION = new AvdManagerConnection(null);
    private static final int MNC_API_LEVEL_23 = 23;
    private static final int LMP_MR1_API_LEVEL_22 = 22;
    public static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    public static final Revision TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"25.0.0 rc1");
    public static final Revision TOOLS_REVISION_25_0_2_RC3 = Revision.parseRevision((String)"25.0.2 rc3");
    public static final Revision PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"23.1.0");
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 2), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 2), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 6), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 10)};
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 4), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 4), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 8), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 12)};
    private AvdManager myAvdManager;
    private static Map<File, AvdManagerConnection> ourCache = ContainerUtil.createWeakMap();
    private static long ourMemorySize = -1L;
    private final FileOp myFileOp;
    private static Function<AndroidSdkHandler, AvdManagerConnection> ourConnectionFactory = AvdManagerConnection::new;
    @Nullable
    private final AndroidSdkHandler mySdkHandler;

    @NotNull
    public static AvdManagerConnection getDefaultAvdManagerConnection() {
        AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (handler.getLocation() == null) {
            AvdManagerConnection avdManagerConnection = NULL_CONNECTION;
            if (avdManagerConnection == null) {
                AvdManagerConnection.$$$reportNull$$$0(0);
            }
            return avdManagerConnection;
        }
        AvdManagerConnection avdManagerConnection = AvdManagerConnection.getAvdManagerConnection(handler);
        if (avdManagerConnection == null) {
            AvdManagerConnection.$$$reportNull$$$0(1);
        }
        return avdManagerConnection;
    }

    @NotNull
    public static synchronized AvdManagerConnection getAvdManagerConnection(@NotNull AndroidSdkHandler handler) {
        File sdkPath;
        if (handler == null) {
            AvdManagerConnection.$$$reportNull$$$0(2);
        }
        if (!ourCache.containsKey(sdkPath = handler.getLocation())) {
            ourCache.put(sdkPath, ourConnectionFactory.apply(handler));
        }
        AvdManagerConnection avdManagerConnection = ourCache.get(sdkPath);
        if (avdManagerConnection == null) {
            AvdManagerConnection.$$$reportNull$$$0(3);
        }
        return avdManagerConnection;
    }

    public AvdManagerConnection(@Nullable AndroidSdkHandler handler) {
        this.mySdkHandler = handler;
        this.myFileOp = handler == null ? FileOpUtils.create() : handler.getFileOp();
    }

    protected static synchronized void setConnectionFactory(Function<AndroidSdkHandler, AvdManagerConnection> factory) {
        ourCache.clear();
        ourConnectionFactory = factory;
    }

    private boolean initIfNecessary() {
        if (this.myAvdManager == null) {
            if (this.mySdkHandler == null) {
                IJ_LOG.warn("No Android SDK Found");
                return false;
            }
            try {
                this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)this.mySdkHandler, (File)new File(AndroidLocation.getAvdFolder()), (ILogger)SDK_LOG, (FileOp)this.myFileOp);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not instantiate AVD Manager from SDK", (Throwable)e);
                return false;
            }
            if (this.myAvdManager == null) {
                return false;
            }
        }
        return true;
    }

    private File getBinaryLocation(String filename) {
        assert (this.mySdkHandler != null);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", REPO_LOG);
        if (sdkPackage == null) {
            sdkPackage = this.mySdkHandler.getLocalPackage("tools", REPO_LOG);
        }
        if (sdkPackage != null) {
            return new File(sdkPackage.getLocation(), filename);
        }
        return new File(this.mySdkHandler.getLocation(), FileUtil.join((String[])new String[]{SdkConstants.OS_SDK_TOOLS_FOLDER, filename}));
    }

    private File getEmulatorBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR);
    }

    public File getEmulatorCheckBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR_CHECK);
    }

    @Nullable
    private SystemImageUpdateDependency[] getSystemImageUpdateDependencies() {
        assert (this.mySdkHandler != null);
        LocalPackage info = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("tools");
        if (info == null) {
            return null;
        }
        if (info.getVersion().compareTo(TOOLS_REVISION_25_0_2_RC3) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3;
        }
        if (info.getVersion().compareTo(TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2;
        }
        return null;
    }

    private boolean hasQEMU2Installed() {
        return this.getSystemImageUpdateDependencies() != null;
    }

    private boolean hasPlatformToolsForQEMU2Installed() {
        assert (this.mySdkHandler != null);
        LocalPackage info = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("platform-tools");
        if (info == null) {
            return false;
        }
        return info.getVersion().compareTo(PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0;
    }

    private boolean hasSystemImagesForQEMU2Installed() {
        return this.getSystemImageUpdates().isEmpty();
    }

    @NotNull
    public List<String> getSystemImageUpdates() {
        ArrayList requested = Lists.newArrayList();
        SystemImageUpdateDependency[] dependencies = this.getSystemImageUpdateDependencies();
        if (dependencies == null) {
            ArrayList arrayList = requested;
            if (arrayList == null) {
                AvdManagerConnection.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        assert (this.mySdkHandler != null);
        block0: for (SystemImage systemImage : this.mySdkHandler.getSystemImageManager(REPO_LOG).getImages()) {
            for (SystemImageUpdateDependency dependency : dependencies) {
                if (!dependency.updateRequired(systemImage)) continue;
                requested.add(systemImage.getPackage().getPath());
                continue block0;
            }
        }
        ArrayList arrayList = requested;
        if (arrayList == null) {
            AvdManagerConnection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!this.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                AvdManagerConnection.$$$reportNull$$$0(6);
            }
            return immutableList;
        }
        if (forceRefresh) {
            try {
                this.myAvdManager.reloadAvds(SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        ArrayList avdInfos = Lists.newArrayList((Object[])this.myAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo info : avdInfos) {
            if (info.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            this.updateDeviceChanged(info);
            needsRefresh = true;
        }
        if (needsRefresh) {
            List<AvdInfo> list = this.getAvds(true);
            if (list == null) {
                AvdManagerConnection.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList arrayList = avdInfos;
        if (arrayList == null) {
            AvdManagerConnection.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public boolean deleteAvd(@NotNull String avdName) {
        if (avdName == null) {
            AvdManagerConnection.$$$reportNull$$$0(9);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        AvdInfo info = this.myAvdManager.getAvd(avdName, false);
        if (info == null) {
            return false;
        }
        return this.deleteAvd(info);
    }

    public boolean deleteAvd(@NotNull AvdInfo info) {
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(10);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.deleteAvd(info, SDK_LOG);
    }

    public boolean isAvdRunning(@NotNull AvdInfo info) {
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(11);
        }
        return this.myAvdManager.isAvdRunning(info, SDK_LOG);
    }

    public void stopAvd(@NotNull AvdInfo info) {
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(12);
        }
        this.myAvdManager.stopAvd(info);
    }

    @NotNull
    public ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info) {
        ProcessHandler processHandler;
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(13);
        }
        if (!this.initIfNecessary()) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("No Android SDK Found"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(14);
            }
            return listenableFuture;
        }
        AccelerationErrorCode error = this.checkAcceleration();
        ListenableFuture<IDevice> errorResult = this.handleAccelerationError(project, info, error);
        if (errorResult != null) {
            ListenableFuture<IDevice> listenableFuture = errorResult;
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(15);
            }
            return listenableFuture;
        }
        File emulatorBinary = this.getEmulatorBinary();
        if (!emulatorBinary.isFile()) {
            IJ_LOG.error("No emulator binary found!");
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("No emulator binary found"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(16);
            }
            return listenableFuture;
        }
        String avdName = info.getName();
        if (this.myAvdManager.isAvdRunning(info, SDK_LOG)) {
            String baseFolder;
            try {
                baseFolder = this.myAvdManager.getBaseAvdFolder().getAbsolutePath();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                baseFolder = "$HOME";
            }
            String message = String.format("AVD %1$s is already running.\nIf that is not the case, delete the files at\n   %2$s/%1$s.avd/*.lock\nand try again.", avdName, baseFolder);
            Messages.showErrorDialog((Project)project, (String)message, (String)"AVD Manager");
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(message));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(17);
            }
            return listenableFuture;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(emulatorBinary.getPath());
        this.addParameters(info, commandLine);
        EmulatorRunner runner = new EmulatorRunner(commandLine, info);
        EmulatorRunner.ProcessOutputCollector collector = new EmulatorRunner.ProcessOutputCollector();
        runner.addProcessListener((ProcessListener)collector);
        try {
            processHandler = runner.start();
        }
        catch (ExecutionException e) {
            IJ_LOG.error("Error launching emulator", (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(String.format("Error launching emulator %1$s ", avdName), e));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(18);
            }
            return listenableFuture;
        }
        BackgroundableProcessIndicator p = this.hasQEMU2Installed() ? new BackgroundableProcessIndicator(project, "Launching Emulator", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false) : new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> AvdManagerConnection.lambda$startAvd$1((ProgressWindow)p, processHandler, collector, project, avdName));
        ListenableFuture<IDevice> listenableFuture = EmulatorConnectionListener.getDeviceForEmulator(project, info.getName(), processHandler, 5L, TimeUnit.MINUTES);
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(19);
        }
        return listenableFuture;
    }

    private static String limitErrorMessage(@NotNull String message) {
        int offset;
        if (message == null) {
            AvdManagerConnection.$$$reportNull$$$0(20);
        }
        if ((offset = StringUtil.lineColToOffset((CharSequence)message, (int)30, (int)0)) < 0) {
            offset = message.length();
        }
        return message.substring(0, Math.min(offset, 1024));
    }

    protected void addParameters(@NotNull AvdInfo info, GeneralCommandLine commandLine) {
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(21);
        }
        Map properties = info.getProperties();
        String netDelay = (String)properties.get("runtime.network.latency");
        String netSpeed = (String)properties.get("runtime.network.speed");
        if (netDelay != null) {
            commandLine.addParameters(new String[]{"-netdelay", netDelay});
        }
        if (netSpeed != null) {
            commandLine.addParameters(new String[]{"-netspeed", netSpeed});
        }
        commandLine.addParameters(new String[]{"-avd", info.getName()});
    }

    @Nullable
    private ListenableFuture<IDevice> handleAccelerationError(@Nullable Project project, @NotNull AvdInfo info, @NotNull AccelerationErrorCode error) {
        if (info == null) {
            AvdManagerConnection.$$$reportNull$$$0(22);
        }
        if (error == null) {
            AvdManagerConnection.$$$reportNull$$$0(23);
        }
        switch (error) {
            case ALREADY_INSTALLED: {
                return null;
            }
            case TOOLS_UPDATE_REQUIRED: 
            case PLATFORM_TOOLS_UPDATE_ADVISED: 
            case SYSTEM_IMAGE_UPDATE_ADVISED: {
                return null;
            }
            case NO_EMULATOR_INSTALLED: {
                break;
            }
            default: {
                boolean isAvdIntel;
                Abi abi = Abi.getEnum((String)info.getAbiType());
                boolean bl = isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
                if (isAvdIntel) break;
                return null;
            }
        }
        String accelerator = SystemInfo.isLinux ? "KVM" : "Intel HAXM";
        int result = Messages.showOkCancelDialog((Project)project, (String)String.format("%1$s is required to run this AVD.\n%2$s\n\n%3$s\n", accelerator, error.getProblem(), error.getSolutionMessage()), (String)error.getSolution().getDescription(), (Icon)AllIcons.General.WarningDialog);
        if (result != 0 || error.getSolution() == AccelerationErrorSolution.SolutionCode.NONE) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Could not start AVD"));
        }
        SettableFuture future = SettableFuture.create();
        Runnable retry = () -> {
            if (info == null) {
                AvdManagerConnection.$$$reportNull$$$0(37);
            }
            future.set(this.startAvd(project, info));
        };
        Runnable cancel = () -> future.setException((Throwable)new RuntimeException("Retry after fixing problem by hand"));
        Runnable action = AccelerationErrorSolution.getActionForFix(error, project, retry, cancel);
        ApplicationManager.getApplication().invokeLater(action);
        return Futures.dereference((ListenableFuture)future);
    }

    public AccelerationErrorCode checkAcceleration() {
        int exitValue;
        if (!this.initIfNecessary()) {
            return AccelerationErrorCode.UNKNOWN_ERROR;
        }
        File emulatorBinary = this.getEmulatorBinary();
        if (!emulatorBinary.isFile()) {
            return AccelerationErrorCode.NO_EMULATOR_INSTALLED;
        }
        if (AvdManagerConnection.getMemorySize() < Storage.Unit.GiB.getNumberOfBytes()) {
            return AccelerationErrorCode.NOT_ENOUGH_MEMORY;
        }
        if (!this.hasQEMU2Installed()) {
            return AccelerationErrorCode.TOOLS_UPDATE_REQUIRED;
        }
        File checkBinary = this.getEmulatorCheckBinary();
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (checkBinary.isFile()) {
            commandLine.setExePath(checkBinary.getPath());
            commandLine.addParameter("accel");
        } else {
            commandLine.setExePath(emulatorBinary.getPath());
            commandLine.addParameter("-accel-check");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            ProcessOutput output = process.runProcess();
            exitValue = output.getExitCode();
        }
        catch (ExecutionException e) {
            exitValue = AccelerationErrorCode.UNKNOWN_ERROR.getErrorCode();
        }
        if (exitValue != 0) {
            return AccelerationErrorCode.fromExitCode(exitValue);
        }
        if (!this.hasPlatformToolsForQEMU2Installed()) {
            return AccelerationErrorCode.PLATFORM_TOOLS_UPDATE_ADVISED;
        }
        if (!this.hasSystemImagesForQEMU2Installed()) {
            return AccelerationErrorCode.SYSTEM_IMAGE_UPDATE_ADVISED;
        }
        return AccelerationErrorCode.ALREADY_INSTALLED;
    }

    @Nullable
    public AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device, @NotNull SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable File skinFolder, @NotNull Map<String, String> hardwareProperties, boolean createSnapshot) {
        boolean success;
        File avdFolder;
        if (avdName == null) {
            AvdManagerConnection.$$$reportNull$$$0(24);
        }
        if (device == null) {
            AvdManagerConnection.$$$reportNull$$$0(25);
        }
        if (systemImageDescription == null) {
            AvdManagerConnection.$$$reportNull$$$0(26);
        }
        if (orientation == null) {
            AvdManagerConnection.$$$reportNull$$$0(27);
        }
        if (hardwareProperties == null) {
            AvdManagerConnection.$$$reportNull$$$0(28);
        }
        if (!this.initIfNecessary()) {
            return null;
        }
        try {
            avdFolder = currentInfo != null ? new File(currentInfo.getDataFolderPath()) : AvdInfo.getDefaultAvdFolder((AvdManager)this.myAvdManager, (String)avdName, (FileOp)this.myFileOp, (boolean)true);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            IJ_LOG.error("Could not create AVD " + avdName, (Throwable)e);
            return null;
        }
        Dimension resolution = device.getScreenSize(orientation);
        assert (resolution != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            skinFolder = AvdManagerConnection.getRoundSkin(systemImageDescription);
        }
        if (FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            skinFolder = null;
        }
        if (skinFolder == null) {
            skinName = String.format("%dx%d", Math.round(resolution.getWidth()), Math.round(resolution.getHeight()));
        }
        if (orientation == ScreenOrientation.LANDSCAPE) {
            hardwareProperties.put("hw.initialOrientation", ScreenOrientation.LANDSCAPE.getShortDisplayValue().toLowerCase(Locale.ROOT));
        }
        if (currentInfo != null && !avdName.equals(currentInfo.getName()) && !(success = this.myAvdManager.moveAvd(currentInfo, avdName, currentInfo.getDataFolderPath(), SDK_LOG))) {
            return null;
        }
        return this.myAvdManager.createAvd(avdFolder, avdName, systemImageDescription.getSystemImage(), skinFolder, skinName, sdCard, hardwareProperties, device.getBootProps(), createSnapshot, false, currentInfo != null, SDK_LOG);
    }

    @Nullable
    private static File getRoundSkin(SystemImageDescription systemImageDescription) {
        File[] skins;
        for (File skin : skins = systemImageDescription.getSkins()) {
            if (!skin.getName().contains("Round")) continue;
            return skin;
        }
        return null;
    }

    public static boolean doesSystemImageSupportQemu2(@Nullable SystemImageDescription description, @NotNull FileOp fileOp) {
        if (fileOp == null) {
            AvdManagerConnection.$$$reportNull$$$0(29);
        }
        if (description == null) {
            return false;
        }
        ISystemImage systemImage = description.getSystemImage();
        if (systemImage == null) {
            return false;
        }
        File location = systemImage.getLocation();
        if (!fileOp.isDirectory(location)) {
            return false;
        }
        String[] files = fileOp.list(location, null);
        if (files != null) {
            for (String filename : files) {
                if (!FileUtil.getNameWithoutExtension((String)filename).equals("kernel-ranchu")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean avdExists(String candidate) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.getAvd(candidate, false) != null;
    }

    static boolean isAvdRepairable(@NotNull AvdInfo.AvdStatus avdStatus) {
        if (avdStatus == null) {
            AvdManagerConnection.$$$reportNull$$$0(30);
        }
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING || avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_MISSING;
    }

    public static boolean isSystemImageDownloadProblem(@NotNull AvdInfo.AvdStatus status) {
        if (status == null) {
            AvdManagerConnection.$$$reportNull$$$0(31);
        }
        switch (status) {
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return true;
            }
        }
        return false;
    }

    public AvdInfo reloadAvd(@NotNull AvdInfo avdInfo) throws AndroidLocation.AndroidLocationException {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(32);
        }
        return this.myAvdManager.reloadAvd(avdInfo, SDK_LOG);
    }

    @Nullable
    public static String getRequiredSystemImagePath(@NotNull AvdInfo avdInfo) {
        String imageSystemDir;
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(33);
        }
        if ((imageSystemDir = (String)avdInfo.getProperties().get("image.sysdir.1")) == null) {
            return null;
        }
        return StringUtil.trimEnd((String)imageSystemDir.replace(File.separatorChar, ';'), (char)';');
    }

    public boolean updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(34);
        }
        if (this.initIfNecessary()) {
            try {
                return this.myAvdManager.updateDeviceChanged(avdInfo, SDK_LOG) != null;
            }
            catch (IOException e) {
                IJ_LOG.warn("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(35);
        }
        if (this.initIfNecessary()) {
            File userdataImage = new File(avdInfo.getDataFolderPath(), "userdata-qemu.img");
            if (userdataImage.isFile()) {
                return userdataImage.delete();
            }
            return true;
        }
        return false;
    }

    public static String getAvdDisplayName(@NotNull AvdInfo avdInfo) {
        String displayName;
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(36);
        }
        if ((displayName = (String)avdInfo.getProperties().get("avd.ini.displayname")) == null) {
            displayName = avdInfo.getName().replaceAll("[_-]+", " ");
        }
        return displayName;
    }

    public String uniquifyDisplayName(String name) {
        int suffix = 1;
        String result = name;
        while (this.findAvdWithName(result)) {
            result = String.format("%1$s %2$d", name, ++suffix);
        }
        return result;
    }

    public boolean findAvdWithName(String name) {
        for (AvdInfo avd : this.getAvds(false)) {
            if (!AvdManagerConnection.getAvdDisplayName(avd).equals(name)) continue;
            return true;
        }
        return false;
    }

    public static long getMemorySize() {
        if (ourMemorySize < 0L) {
            ourMemorySize = AvdManagerConnection.checkMemorySize();
        }
        return ourMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            IJ_LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$startAvd$1(ProgressWindow p, ProcessHandler processHandler, EmulatorRunner.ProcessOutputCollector collector, @Nullable Project project, String avdName) {
        try {
            p.start();
            p.setText("Starting AVD...");
            for (double d = 0.0; d < 1.0; d += 0.0125) {
                p.setFraction(d);
                Thread.sleep(100L);
                if (!processHandler.isProcessTerminated()) continue;
                break;
            }
        }
        catch (InterruptedException d) {
        }
        finally {
            p.stop();
            p.processFinish();
        }
        processHandler.removeProcessListener((ProcessListener)collector);
        String message = AvdManagerConnection.limitErrorMessage(collector.getText());
        if (message.toLowerCase(Locale.ROOT).contains("error") || processHandler.isProcessTerminated() && !message.trim().isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Cannot launch AVD in emulator.\nOutput:\n" + message), (String)avdName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/AvdManagerConnection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemImageDescription";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardwareProperties";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOp";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdStatus";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAvdManagerConnection";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/AvdManagerConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvdManagerConnection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemImageUpdates";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvds";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "startAvd";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAvdManagerConnection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteAvd";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvdRunning";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "stopAvd";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startAvd";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "limitErrorMessage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleAccelerationError";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateAvd";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doesSystemImageSupportQemu2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAvdRepairable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSystemImageDownloadProblem";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reloadAvd";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredSystemImagePath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateDeviceChanged";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "wipeUserData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAvdDisplayName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleAccelerationError$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SystemImageUpdateDependency {
        private final int myFeatureLevel;
        private final IdDisplay myTag;
        private final int myRequiredMajorRevision;

        public SystemImageUpdateDependency(int featureLevel, @NotNull IdDisplay tag, int requiredMajorRevision) {
            if (tag == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(0);
            }
            this.myFeatureLevel = featureLevel;
            this.myTag = tag;
            this.myRequiredMajorRevision = requiredMajorRevision;
        }

        public boolean updateRequired(@NotNull SystemImage image) {
            if (image == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(1);
            }
            return this.updateRequired(image.getAbiType(), image.getAndroidVersion().getFeatureLevel(), image.getTag(), image.getRevision());
        }

        public boolean updateRequired(@NotNull String abiType, int featureLevel, @NotNull IdDisplay tag, @NotNull Revision revision) {
            Abi abi;
            if (abiType == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(2);
            }
            if (tag == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(3);
            }
            if (revision == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(4);
            }
            boolean isAvdIntel = (abi = Abi.getEnum((String)abiType)) == Abi.X86 || abi == Abi.X86_64;
            return isAvdIntel && featureLevel == this.myFeatureLevel && this.myTag.equals((Object)tag) && revision.getMajor() < this.myRequiredMajorRevision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "abiType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/avdmanager/AvdManagerConnection$SystemImageUpdateDependency";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateRequired";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

