/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Keyboard;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdScreenData;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public final class AvdHardwareData {
    private AvdDeviceData myDeviceData;

    public AvdHardwareData(AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
    }

    @NotNull
    public Hardware buildHardware() {
        Hardware hardware = new Hardware();
        hardware.addNetwork(Network.BLUETOOTH);
        hardware.addNetwork(Network.WIFI);
        hardware.addNetwork(Network.NFC);
        hardware.addSensor(Sensor.BAROMETER);
        hardware.addSensor(Sensor.COMPASS);
        hardware.addSensor(Sensor.LIGHT_SENSOR);
        hardware.setHasMic(true);
        hardware.addInternalStorage(new Storage(4L, Storage.Unit.GiB));
        hardware.setCpu("Generic CPU");
        hardware.setGpu("Generic GPU");
        hardware.addAllSupportedAbis(EnumSet.allOf(Abi.class));
        hardware.setChargeType(PowerType.BATTERY);
        if (((Boolean)this.myDeviceData.hasAccelerometer().get()).booleanValue()) {
            hardware.addSensor(Sensor.ACCELEROMETER);
        }
        if (((Boolean)this.myDeviceData.hasGyroscope().get()).booleanValue()) {
            hardware.addSensor(Sensor.GYROSCOPE);
        }
        if (((Boolean)this.myDeviceData.hasGps().get()).booleanValue()) {
            hardware.addSensor(Sensor.GPS);
        }
        if (((Boolean)this.myDeviceData.hasProximitySensor().get()).booleanValue()) {
            hardware.addSensor(Sensor.PROXIMITY_SENSOR);
        }
        if (((Boolean)this.myDeviceData.hasBackCamera().get()).booleanValue()) {
            hardware.addCamera(new Camera(CameraLocation.BACK, true, true));
        }
        if (((Boolean)this.myDeviceData.hasFrontCamera().get()).booleanValue()) {
            hardware.addCamera(new Camera(CameraLocation.FRONT, true, true));
        }
        if (((Boolean)this.myDeviceData.hasHardwareKeyboard().get()).booleanValue()) {
            hardware.setKeyboard(Keyboard.QWERTY);
        } else {
            hardware.setKeyboard(Keyboard.NOKEY);
        }
        if (((Boolean)this.myDeviceData.hasHardwareButtons().get()).booleanValue()) {
            hardware.setButtonType(ButtonType.HARD);
        } else {
            hardware.setButtonType(ButtonType.SOFT);
        }
        if (this.myDeviceData.navigation().getValueOrNull() != null) {
            hardware.setNav(this.myDeviceData.navigation().getValue());
        }
        if (this.myDeviceData.customSkinFile().getValueOrNull() != null) {
            hardware.setSkinFile(this.myDeviceData.customSkinFile().getValue());
        }
        hardware.setRam((Storage)this.myDeviceData.ramStorage().get());
        hardware.setScreen(new AvdScreenData(this.myDeviceData).createScreen());
        Hardware hardware2 = hardware;
        if (hardware2 == null) {
            AvdHardwareData.$$$reportNull$$$0(0);
        }
        return hardware2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdHardwareData", "buildHardware"));
    }
}

