/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdSummaryAction;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.DeleteAvdAction;
import com.android.tools.idea.avdmanager.DuplicateAvdAction;
import com.android.tools.idea.avdmanager.EditAvdAction;
import com.android.tools.idea.avdmanager.InstallSystemImageAction;
import com.android.tools.idea.avdmanager.RepairAvdAction;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.android.tools.idea.avdmanager.ShowAvdOnDiskAction;
import com.android.tools.idea.avdmanager.StopAvdAction;
import com.android.tools.idea.avdmanager.WipeAvdDataAction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdActionPanel
extends JPanel
implements AvdUiAction.AvdInfoProvider {
    @NotNull
    private final AvdInfo myAvdInfo;
    private final AvdRefreshProvider myRefreshProvider;
    private final JBPopupMenu myOverflowMenu;
    private final FocusableHyperlinkLabel myOverflowMenuButton;
    private final Border myMargins;
    public List<FocusableHyperlinkLabel> myVisibleComponents;
    private boolean myFocused;
    private int myFocusedComponent;

    public AvdActionPanel(@NotNull AvdInfo avdInfo, int numVisibleActions, AvdRefreshProvider refreshProvider) {
        if (avdInfo == null) {
            AvdActionPanel.$$$reportNull$$$0(0);
        }
        this.myOverflowMenu = new JBPopupMenu();
        this.myOverflowMenuButton = new FocusableHyperlinkLabel("", AllIcons.ToolbarDecorator.Mac.MoveDown);
        this.myMargins = JBUI.Borders.empty((int)5, (int)3, (int)5, (int)3);
        this.myVisibleComponents = Lists.newArrayList();
        this.myFocusedComponent = -1;
        this.myRefreshProvider = refreshProvider;
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.myAvdInfo = avdInfo;
        List<AvdUiAction> actions = this.getActions();
        this.setLayout(new FlowLayout(2, 3, 0));
        int visibleActionCount = 0;
        boolean errorState = false;
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            AvdUiAction action = null;
            if (AvdManagerConnection.isSystemImageDownloadProblem(avdInfo.getStatus())) {
                action = new InstallSystemImageAction(this);
            } else if (AvdManagerConnection.isAvdRepairable(avdInfo.getStatus())) {
                action = new RepairAvdAction(this);
            }
            if (action != null) {
                FocusableHyperlinkLabel repairAction = new FocusableHyperlinkLabel(action.getText(), action.getIcon());
                this.add((Component)((Object)repairAction));
                repairAction.addHyperlinkListener(action);
                this.myVisibleComponents.add(repairAction);
            } else {
                this.add((Component)new JBLabel("Failed to load", AllIcons.General.BalloonError, 10));
            }
            numVisibleActions = 0;
            errorState = true;
        }
        for (AvdUiAction action : actions) {
            FocusableHyperlinkLabel actionLabel;
            if (errorState || numVisibleActions != -1 && visibleActionCount >= numVisibleActions) {
                JBMenuItem menuItem = new JBMenuItem((Action)action);
                this.myOverflowMenu.add((JMenuItem)menuItem);
                actionLabel = menuItem;
            } else {
                actionLabel = new FocusableHyperlinkLabel("", action.getIcon());
                actionLabel.addHyperlinkListener(action);
                this.add((Component)((Object)actionLabel));
                this.myVisibleComponents.add(actionLabel);
                ++visibleActionCount;
            }
            ((JComponent)((Object)actionLabel)).setToolTipText(action.getDescription());
            ((JComponent)((Object)actionLabel)).setBorder(this.myMargins);
        }
        this.myOverflowMenuButton.setBorder(this.myMargins);
        this.add((Component)((Object)this.myOverflowMenuButton));
        this.myVisibleComponents.add(this.myOverflowMenuButton);
        this.myOverflowMenuButton.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AvdActionPanel.this.myOverflowMenu.show((Component)((Object)AvdActionPanel.this.myOverflowMenuButton), AvdActionPanel.this.myOverflowMenuButton.getX() - ((AvdActionPanel)AvdActionPanel.this).myOverflowMenu.getPreferredSize().width, AvdActionPanel.this.myOverflowMenuButton.getY());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    AvdActionPanel.this.runFocusedAction();
                }
            }
        });
    }

    @NotNull
    private List<AvdUiAction> getActions() {
        ImmutableList immutableList = ImmutableList.of((Object)new RunAvdAction(this), (Object)new EditAvdAction(this), (Object)new DuplicateAvdAction(this), (Object)new WipeAvdDataAction(this), (Object)new ShowAvdOnDiskAction(this), (Object)new AvdSummaryAction(this), (Object)new DeleteAvdAction(this), (Object)new StopAvdAction(this));
        if (immutableList == null) {
            AvdActionPanel.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public AvdInfo getAvdInfo() {
        AvdInfo avdInfo = this.myAvdInfo;
        if (avdInfo == null) {
            AvdActionPanel.$$$reportNull$$$0(2);
        }
        return avdInfo;
    }

    @Override
    public void refreshAvds() {
        this.myRefreshProvider.refreshAvds();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myRefreshProvider.getProject();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myRefreshProvider.getComponent();
        if (jComponent == null) {
            AvdActionPanel.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public void showPopup(@NotNull Component c, @NotNull MouseEvent e) {
        if (c == null) {
            AvdActionPanel.$$$reportNull$$$0(4);
        }
        if (e == null) {
            AvdActionPanel.$$$reportNull$$$0(5);
        }
        this.myOverflowMenu.show(c, e.getX(), e.getY());
    }

    public void runFocusedAction() {
        this.myVisibleComponents.get(this.myFocusedComponent).doClick();
    }

    public boolean cycleFocus(boolean backward) {
        if (backward) {
            if (this.myFocusedComponent == -1) {
                this.myFocusedComponent = this.myVisibleComponents.size() - 1;
                return true;
            }
            --this.myFocusedComponent;
            return this.myFocusedComponent != -1;
        }
        if (this.myFocusedComponent == this.myVisibleComponents.size() - 1) {
            this.myFocusedComponent = -1;
            return false;
        }
        ++this.myFocusedComponent;
        return true;
    }

    public void setFocused(boolean focused) {
        this.myFocused = focused;
        if (!focused) {
            this.myFocusedComponent = -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/AvdActionPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/AvdActionPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvdInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FocusableHyperlinkLabel
    extends HyperlinkLabel {
        FocusableHyperlinkLabel(String text, Icon icon) {
            super(text, JBColor.foreground(), JBColor.background(), JBColor.foreground());
            this.setIcon(icon);
            this.setOpaque(false);
            this.setUseIconAsLink(true);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (AvdActionPanel.this.myFocused && AvdActionPanel.this.myFocusedComponent != -1 && AvdActionPanel.this.myVisibleComponents.get(AvdActionPanel.this.myFocusedComponent) == this) {
                g.setColor(UIUtil.getTableSelectionForeground());
                UIUtil.drawDottedRectangle((Graphics)g, (int)0, (int)0, (int)(this.getWidth() - 2), (int)(this.getHeight() - 2));
            }
        }
    }

    public static interface AvdRefreshProvider {
        public void refreshAvds();

        @Nullable
        public Project getProject();

        @NotNull
        public JComponent getComponent();
    }
}

