/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.view.CardViewPanel;
import com.android.tools.idea.assistant.view.FeatureEntryPoint;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TutorialChooser
extends CardViewPanel {
    private final AnalyticsProvider myAnalyticsProvider;
    private final Project myProject;
    public static final String NAVIGATION_KEY = "studio_tutorial_chooser";

    public TutorialChooser(@NotNull ActionListener listener, @NotNull TutorialBundleData bundle, @NotNull AnalyticsProvider analyticsProvider, @NotNull Project project) {
        if (listener == null) {
            TutorialChooser.$$$reportNull$$$0(0);
        }
        if (bundle == null) {
            TutorialChooser.$$$reportNull$$$0(1);
        }
        if (analyticsProvider == null) {
            TutorialChooser.$$$reportNull$$$0(2);
        }
        if (project == null) {
            TutorialChooser.$$$reportNull$$$0(3);
        }
        super(listener);
        this.myAnalyticsProvider = analyticsProvider;
        this.myProject = project;
        TutorialChooserHeader header = new TutorialChooserHeader(bundle);
        JTextPane welcome = new JTextPane();
        welcome.setOpaque(false);
        String text = "<p class=\"welcome\">" + bundle.getWelcome() + "</p>";
        UIUtils.setHtml(welcome, text, ".welcome { margin: 10px; color: " + UIUtils.getCssColor(UIUtils.getSecondaryColor()) + "}");
        header.add(welcome);
        this.add((Component)header, "North");
        NaturalWidthScrollClient services = new NaturalWidthScrollClient();
        services.setLayout(new GridBagLayout());
        services.setOpaque(false);
        services.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        for (FeatureData featureData : bundle.getFeatures()) {
            FeatureEntryPoint entryPoint = this.createFeatureEntryPoint(featureData);
            services.add((Component)entryPoint, c);
            ++c.gridy;
        }
        GridBagConstraints glueConstraints = new GridBagConstraints();
        glueConstraints.gridx = 0;
        glueConstraints.gridy = c.gridy + 1;
        glueConstraints.gridwidth = 1;
        glueConstraints.gridheight = 1;
        glueConstraints.weightx = 0.0;
        glueConstraints.weighty = 1.0;
        glueConstraints.anchor = 11;
        glueConstraints.fill = 1;
        glueConstraints.insets = new JBInsets(0, 0, 0, 0);
        glueConstraints.ipadx = 0;
        glueConstraints.ipady = 0;
        services.add(Box.createVerticalGlue(), glueConstraints);
        JBScrollPane jBScrollPane = new JBScrollPane((Component)services);
        jBScrollPane.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        jBScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jBScrollPane.setOpaque(false);
        jBScrollPane.getViewport().setOpaque(false);
        this.add((Component)jBScrollPane, "Center");
    }

    private FeatureEntryPoint createFeatureEntryPoint(@NotNull FeatureData feature) {
        if (feature == null) {
            TutorialChooser.$$$reportNull$$$0(4);
        }
        return new FeatureEntryPoint(feature, this.myListener, this.myAnalyticsProvider, this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyticsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/assistant/view/TutorialChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFeatureEntryPoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TutorialChooserHeader
    extends JPanel {
        TutorialChooserHeader(TutorialBundleData bundle) {
            super((LayoutManager)new VerticalFlowLayout());
            this.setOpaque(false);
            if (bundle.getLogo() != null) {
                JBLabel logo = new JBLabel();
                logo.setAlignmentX(0.0f);
                logo.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
                logo.setIcon(bundle.getLogo());
                this.add((Component)logo);
                return;
            }
            JBLabel title = new JBLabel(bundle.getName());
            title.setAlignmentX(0.0f);
            title.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            title.setIcon(bundle.getIcon());
            this.add((Component)title);
        }
    }

    private static class NaturalWidthScrollClient
    extends JPanel
    implements Scrollable {
        private NaturalWidthScrollClient() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

