/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.StatefulButtonUI;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;

public class StatefulButton
extends JPanel {
    private ActionButton myButton;
    private final String mySuccessMessage;
    private StatefulButtonMessage myMessage;
    private AssistActionStateManager myStateManager;
    private final ActionData myAction;
    private final Project myProject;

    public StatefulButton(@NotNull ActionData action, @NotNull ActionListener listener, @NotNull Project project) {
        if (action == null) {
            StatefulButton.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            StatefulButton.$$$reportNull$$$0(1);
        }
        if (project == null) {
            StatefulButton.$$$reportNull$$$0(2);
        }
        super((LayoutManager)new VerticalLayout(5, 2));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.myAction = action;
        this.myProject = project;
        this.mySuccessMessage = action.getSuccessMessage();
        this.myButton = new ActionButton(action, listener, this){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI(StatefulButtonUI.createUI(StatefulButton.this.myButton));
                JButton defaultButton = new JButton();
                Border defaultButtonBorder = defaultButton.getBorder();
                if (defaultButtonBorder instanceof MacIntelliJButtonBorder) {
                    defaultButtonBorder = new DarculaButtonPainter();
                }
                Insets insets = defaultButtonBorder.getBorderInsets(defaultButton);
                this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            }
        };
        this.add(this.myButton);
        this.myButton.setVisible(false);
        for (AssistActionStateManager stateManager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
            if (!stateManager.getId().equals(action.getKey())) continue;
            this.myStateManager = stateManager;
            break;
        }
        if (this.myStateManager != null) {
            this.myStateManager.init(project, action);
            this.myMessage = this.myStateManager.getStateDisplay(project, action, this.mySuccessMessage);
            this.add(this.myMessage);
            this.myMessage.setVisible(false);
            for (Module module : GradleProjectInfo.getInstance(project).getAndroidModules()) {
                MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
                connection.subscribe(StatefulButtonNotifier.BUTTON_STATE_TOPIC, this::updateButtonState);
            }
        }
        this.updateButtonState();
    }

    @NotNull
    public ActionData getActionData() {
        ActionData actionData = this.myAction;
        if (actionData == null) {
            StatefulButton.$$$reportNull$$$0(3);
        }
        return actionData;
    }

    public void updateButtonState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateButtonState);
            return;
        }
        if (this.myStateManager == null) {
            this.myButton.setVisible(true);
            return;
        }
        AssistActionStateManager.ActionState state = this.myStateManager.getState(this.myProject, this.myAction);
        this.remove(this.myMessage);
        this.myMessage = this.myStateManager.getStateDisplay(this.myProject, this.myAction, this.mySuccessMessage);
        this.add(this.myMessage);
        this.revalidate();
        this.repaint();
        if (this.myMessage != null) {
            switch (state) {
                case ERROR: 
                case COMPLETE: {
                    this.myButton.setVisible(false);
                    this.myMessage.setVisible(true);
                    break;
                }
                case IN_PROGRESS: 
                case INCOMPLETE: {
                    this.myButton.setVisible(true);
                    this.myMessage.setVisible(false);
                    break;
                }
                default: {
                    this.myButton.setVisible(true);
                    this.myMessage.setVisible(true);
                }
            }
            return;
        }
        this.myButton.setEnabled(!state.equals((Object)AssistActionStateManager.ActionState.COMPLETE));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            StatefulButton.$$$reportNull$$$0(4);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/assistant/view/StatefulButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/assistant/view/StatefulButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionButton
    extends JButton {
        private final String myKey;
        private final StatefulButton myButtonWrapper;

        public ActionButton(@NotNull ActionData action, @NotNull ActionListener listener, @NotNull StatefulButton wrapper) {
            if (action == null) {
                ActionButton.$$$reportNull$$$0(0);
            }
            if (listener == null) {
                ActionButton.$$$reportNull$$$0(1);
            }
            if (wrapper == null) {
                ActionButton.$$$reportNull$$$0(2);
            }
            super(action.getLabel());
            this.myKey = action.getKey();
            this.myButtonWrapper = wrapper;
            this.addActionListener(listener);
            this.setOpaque(false);
        }

        @NotNull
        public String getKey() {
            String string = this.myKey;
            if (string == null) {
                ActionButton.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void updateState() {
            this.myButtonWrapper.updateButtonState();
        }

        @NotNull
        public ActionData getActionData() {
            ActionData actionData = this.myButtonWrapper.getActionData();
            if (actionData == null) {
                ActionButton.$$$reportNull$$$0(4);
            }
            return actionData;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myButtonWrapper.getProject();
            if (project == null) {
                ActionButton.$$$reportNull$$$0(5);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/assistant/view/StatefulButton$ActionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/assistant/view/StatefulButton$ActionButton";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionData";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

