/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.apk.viewer.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.diff.ApkDiffEntry;
import com.android.tools.idea.apk.viewer.diff.ApkDiffParser;
import com.android.tools.idea.ddms.EdtExecutor;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ApkDiffPanel {
    private JPanel myContainer;
    private JScrollPane myColumnTreePane;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;

    public ApkDiffPanel(ApkDiffParser apkDiffParser) {
        this.$$$setupUI$$$();
        ListenableFuture<DefaultMutableTreeNode> treeStructureFuture = apkDiffParser.constructTreeStructure();
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result) {
                ApkDiffPanel.this.setRootNode(result);
            }
        };
        Futures.addCallback(treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutor.INSTANCE);
    }

    private void createUIComponents() {
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        Convertor<TreePath, String> convertor = new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                ApkEntry e = ApkEntry.fromNode(path.getLastPathComponent());
                if (e == null) {
                    return null;
                }
                return e.getPath();
            }
        };
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, (Convertor)convertor, true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new ApkViewPanel.NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Old Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new ApkViewPanel.SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getOldSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("New Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new ApkViewPanel.SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getNewSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Diff Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new ApkViewPanel.SizeRenderer((Function<ApkEntry, Long>)((Function)ApkEntry::getSize))));
        this.myColumnTreePane = (JScrollPane)builder.build();
    }

    @NotNull
    public JComponent getContainer() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            ApkDiffPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            ApkDiffPanel.$$$reportNull$$$0(1);
        }
        return tree;
    }

    private void setRootNode(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            ApkDiffPanel.$$$reportNull$$$0(2);
        }
        this.myTreeModel = new DefaultTreeModel(root);
        ApkEntry entry = ApkEntry.fromNode(root);
        assert (entry != null);
        this.myTree.setPaintBusy(false);
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/diff/ApkDiffPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/diff/ApkDiffPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRootNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = this.myColumnTreePane;
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(400, -1), new Dimension(400, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }
}

