/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jf.dexlib2.iface.reference.MethodReference;

public class PackageTreeNode
implements TreeNode {
    @NotNull
    private final String myPackageName;
    @NotNull
    private final String myName;
    @NotNull
    private final NodeType myNodeType;
    @Nullable
    private final PackageTreeNode myParent;
    @NotNull
    private final List<PackageTreeNode> myNodes;
    private int myMethodReferencesCount;
    private int myDefinedMethodsCount;

    public PackageTreeNode(@NotNull String packageName, @NotNull String name, @NotNull NodeType type, @Nullable PackageTreeNode parent) {
        if (packageName == null) {
            PackageTreeNode.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PackageTreeNode.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PackageTreeNode.$$$reportNull$$$0(2);
        }
        this.myMethodReferencesCount = 0;
        this.myDefinedMethodsCount = 0;
        this.myPackageName = packageName;
        this.myName = name;
        this.myNodeType = type;
        this.myParent = parent;
        this.myNodes = new ArrayList<PackageTreeNode>();
    }

    public void sortByCount() {
        for (PackageTreeNode node : this.myNodes) {
            node.sortByCount();
        }
        Collections.sort(this.myNodes, (o1, o2) -> o2.getMethodRefCount() - o1.getMethodRefCount());
    }

    public void insert(@NotNull String parentPackage, @NotNull String qcn, @NotNull MethodReference ref, boolean hasClassDefinition) {
        int i;
        if (parentPackage == null) {
            PackageTreeNode.$$$reportNull$$$0(3);
        }
        if (qcn == null) {
            PackageTreeNode.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            PackageTreeNode.$$$reportNull$$$0(5);
        }
        if ((i = qcn.indexOf(".")) < 0) {
            this.insertClass(parentPackage, qcn, ref, hasClassDefinition);
        } else {
            String segment = qcn.substring(0, i);
            String nextSegment = qcn.substring(i + 1);
            PackageTreeNode node = this.getOrCreateChild(parentPackage, segment, NodeType.PACKAGE);
            node.insert(PackageTreeNode.combine(parentPackage, segment), nextSegment, ref, hasClassDefinition);
            ++this.myMethodReferencesCount;
            if (hasClassDefinition) {
                ++this.myDefinedMethodsCount;
            }
        }
    }

    private static String combine(@NotNull String parentPackage, @NotNull String childName) {
        if (parentPackage == null) {
            PackageTreeNode.$$$reportNull$$$0(6);
        }
        if (childName == null) {
            PackageTreeNode.$$$reportNull$$$0(7);
        }
        return parentPackage.isEmpty() ? childName : parentPackage + "." + childName;
    }

    private void insertClass(@NotNull String parentPackage, @NotNull String className, @NotNull MethodReference ref, boolean hasClassDefinition) {
        if (parentPackage == null) {
            PackageTreeNode.$$$reportNull$$$0(8);
        }
        if (className == null) {
            PackageTreeNode.$$$reportNull$$$0(9);
        }
        if (ref == null) {
            PackageTreeNode.$$$reportNull$$$0(10);
        }
        ++this.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++this.myDefinedMethodsCount;
        }
        PackageTreeNode classNode = this.getOrCreateChild(parentPackage, className, NodeType.CLASS);
        classNode.insertMethod(ref, hasClassDefinition);
    }

    private void insertMethod(@NotNull MethodReference ref, boolean hasClassDefinition) {
        if (ref == null) {
            PackageTreeNode.$$$reportNull$$$0(11);
        }
        ++this.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++this.myDefinedMethodsCount;
        }
        PackageTreeNode methodNode = new PackageTreeNode(ref.getDefiningClass(), PackageTreeNode.formatMethod(ref), NodeType.METHOD, this);
        ++methodNode.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++methodNode.myDefinedMethodsCount;
        }
        this.myNodes.add(methodNode);
    }

    private PackageTreeNode getOrCreateChild(String parentPackage, @NotNull String name, @NotNull NodeType type) {
        if (name == null) {
            PackageTreeNode.$$$reportNull$$$0(12);
        }
        if (type == null) {
            PackageTreeNode.$$$reportNull$$$0(13);
        }
        for (PackageTreeNode node : this.myNodes) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        PackageTreeNode node = new PackageTreeNode(parentPackage, name, type, this);
        this.myNodes.add(node);
        return node;
    }

    @NotNull
    private static String formatMethod(@NotNull MethodReference ref) {
        if (ref == null) {
            PackageTreeNode.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DebuggerUtilsEx.signatureToName((String)ref.getReturnType()));
        sb.append(' ');
        sb.append(ref.getName());
        String paramList = ref.getParameterTypes().stream().map(typeDesc -> DebuggerUtilsEx.signatureToName((String)typeDesc.toString())).collect(Collectors.joining(", "));
        sb.append('(');
        sb.append(paramList);
        sb.append(')');
        String string = sb.toString();
        if (string == null) {
            PackageTreeNode.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public NodeType getNodeType() {
        NodeType nodeType = this.myNodeType;
        if (nodeType == null) {
            PackageTreeNode.$$$reportNull$$$0(16);
        }
        return nodeType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PackageTreeNode.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = PackageTreeNode.combine(this.myPackageName, this.myName);
        if (string == null) {
            PackageTreeNode.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public TreeNode getChildAt(int i) {
        return this.myNodes.get(i);
    }

    @Override
    public int getChildCount() {
        return this.myNodes.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.myNodes.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myNodes.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.myNodes);
    }

    public int getMethodRefCount() {
        return this.myMethodReferencesCount;
    }

    public int getDefinedMethodsCount() {
        return this.myDefinedMethodsCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qcn";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/dex/PackageTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/PackageTreeNode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "insertMethod";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NodeType {
        PACKAGE,
        CLASS,
        METHOD;

    }
}

