/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.apk.viewer.AndroidApplicationInfo;
import com.android.tools.idea.apk.viewer.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.PercentRenderer;
import com.android.tools.idea.ddms.EdtExecutor;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkViewPanel
implements TreeSelectionListener {
    private JPanel myContainer;
    private JScrollPane myColumnTreePane;
    private SimpleColoredComponent myNameComponent;
    private SimpleColoredComponent mySizeComponent;
    private AnimatedIcon myNameAsyncIcon;
    private AnimatedIcon mySizeAsyncIcon;
    private JButton myCompareWithButton;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private Listener myListener;

    public ApkViewPanel(@NotNull ApkParser apkParser) {
        if (apkParser == null) {
            ApkViewPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        ListenableFuture<DefaultMutableTreeNode> treeStructureFuture = apkParser.constructTreeStructure();
        FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result) {
                ApkViewPanel.this.setRootNode(result);
            }
        };
        Futures.addCallback(treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutor.INSTANCE);
        ListenableFuture<DefaultMutableTreeNode> compressedTreeFuture = apkParser.constructTreeStructureWithCompressedSizes();
        FutureCallBackAdapter<DefaultMutableTreeNode> refreshTree = new FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result) {
                ApkViewPanel.this.refreshTree();
            }
        };
        Futures.addCallback(compressedTreeFuture, (FutureCallback)refreshTree, (Executor)EdtExecutor.INSTANCE);
        this.mySizeComponent.setToolTipText(AndroidBundle.message("apk.viewer.size.types.tooltip", new Object[0]));
        this.myContainer.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myCompareWithButton.addActionListener(e -> {
            if (this.myListener != null) {
                this.myListener.selectApkAndCompare();
            }
        });
        this.myNameAsyncIcon.setVisible(true);
        this.myNameComponent.append("Parsing Manifest");
        Futures.addCallback(apkParser.getApplicationInfo(), (FutureCallback)new FutureCallBackAdapter<AndroidApplicationInfo>(){

            @Override
            public void onSuccess(AndroidApplicationInfo result) {
                ApkViewPanel.this.setAppInfo(result);
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.mySizeAsyncIcon.setVisible(true);
        this.mySizeComponent.append("Estimating download size..");
        Futures.addCallback((ListenableFuture)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{apkParser.getUncompressedApkSize(), apkParser.getCompressedFullApkSize()}), (FutureCallback)new FutureCallBackAdapter<List<Long>>(){

            @Override
            public void onSuccess(List<Long> result) {
                long uncompressed = result.get(0);
                Long compressed = result.get(1);
                ApkViewPanel.this.setApkSizes(uncompressed, compressed == null ? 0L : compressed);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private void createUIComponents() {
        this.myNameAsyncIcon = new AsyncProcessIcon("aapt xmltree manifest");
        this.mySizeAsyncIcon = new AsyncProcessIcon("estimating apk size");
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, path -> {
            ApkEntry e = ApkEntry.fromNode(path.getLastPathComponent());
            if (e == null) {
                return null;
            }
            return e.getPath();
        }, true);
        PercentRenderer.PercentProvider percentProvider = (jTree, value, row) -> {
            ApkEntry entry = ApkEntry.fromNode(value);
            ApkEntry rootEntry = ApkEntry.fromNode(jTree.getModel().getRoot());
            if (entry == null || rootEntry == null) {
                return 0.0;
            }
            if (!entry.isCompressedSizeKnown() || !rootEntry.isCompressedSizeKnown()) {
                return 0.0;
            }
            return (double)entry.getCompressedSize() / (double)rootEntry.getCompressedSize();
        };
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Raw File Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Download Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("% of Total Download size").setPreferredWidth(150).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new PercentRenderer(percentProvider)));
        this.myColumnTreePane = (JScrollPane)builder.build();
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void setListener(@NotNull Listener listener) {
        if (listener == null) {
            ApkViewPanel.$$$reportNull$$$0(1);
        }
        this.myListener = listener;
    }

    private void setRootNode(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            ApkViewPanel.$$$reportNull$$$0(2);
        }
        this.myTreeModel = new DefaultTreeModel(root);
        ApkEntry entry = ApkEntry.fromNode(root);
        assert (entry != null);
        this.myTree.setPaintBusy(!entry.isCompressedSizeKnown());
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private void refreshTree() {
        this.myTree.setPaintBusy(false);
        this.myTreeModel.reload();
    }

    private void setApkSizes(long uncompressed, long compressedFullApk) {
        this.mySizeComponent.clear();
        if (this.mySizeAsyncIcon != null) {
            this.mySizeAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.mySizeAsyncIcon);
            this.mySizeAsyncIcon = null;
        }
        this.mySizeComponent.setIcon(AllIcons.General.BalloonInformation);
        this.mySizeComponent.append("Raw File Size: ");
        this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(uncompressed), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.mySizeComponent.append(", Download Size: ");
        this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(compressedFullApk), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private void setAppInfo(@NotNull AndroidApplicationInfo appInfo) {
        if (appInfo == null) {
            ApkViewPanel.$$$reportNull$$$0(3);
        }
        this.myNameComponent.clear();
        if (this.myNameAsyncIcon != null) {
            this.myNameAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myNameAsyncIcon);
            this.myNameAsyncIcon = null;
        }
        this.myNameComponent.append(appInfo.packageId, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myNameComponent.append(" (version ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(appInfo.versionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    public JComponent getContainer() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            ApkViewPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            ApkViewPanel.$$$reportNull$$$0(5);
        }
        return tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ApkEntry selectedEntry = ApkEntry.fromNode(e.getPath().getLastPathComponent());
        if (this.myListener != null) {
            this.myListener.selectionChanged(selectedEntry);
        }
    }

    public static String getHumanizedSize(long sizeInBytes) {
        long kilo = 1024L;
        long mega = kilo * kilo;
        DecimalFormat formatter = new DecimalFormat("#.#");
        int sign = sizeInBytes < 0L ? -1 : 1;
        if ((sizeInBytes = Math.abs(sizeInBytes)) > mega) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)mega) + " MB";
        }
        if (sizeInBytes > kilo) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)kilo) + " KB";
        }
        return (long)sign * sizeInBytes + " B";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkViewPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRootNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAppInfo";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JScrollPane jScrollPane = this.myColumnTreePane;
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myNameComponent = simpleColoredComponent2 = new SimpleColoredComponent();
        Component component = jPanel2.add((Component)simpleColoredComponent2);
        AnimatedIcon animatedIcon = this.myNameAsyncIcon;
        Component component2 = jPanel2.add((Component)animatedIcon);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.mySizeComponent = simpleColoredComponent = new SimpleColoredComponent();
        Component component3 = jPanel3.add((Component)simpleColoredComponent);
        AnimatedIcon animatedIcon2 = this.mySizeAsyncIcon;
        Component component4 = jPanel3.add((Component)animatedIcon2);
        this.myCompareWithButton = jButton = new JButton();
        jButton.setText("Compare with...");
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    public static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private Function<ApkEntry, Long> mySizeMapper;

        public SizeRenderer(boolean useCompressedSize) {
            this((Function<ApkEntry, Long>)((Function)entry -> {
                if (useCompressedSize) {
                    if (entry.isCompressedSizeKnown()) {
                        return entry.getCompressedSize();
                    }
                    return 0L;
                }
                return entry.getSize();
            }));
        }

        public SizeRenderer(Function<ApkEntry, Long> sizeMapper) {
            this.mySizeMapper = sizeMapper;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                SizeRenderer.$$$reportNull$$$0(0);
            }
            ApkEntry entry = ApkEntry.fromNode(value);
            ApkEntry root = ApkEntry.fromNode(tree.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.setTextAlign(4);
            this.append(ApkViewPanel.getHumanizedSize((Long)this.mySizeMapper.fun((Object)entry)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/ApkViewPanel$SizeRenderer", "customizeCellRenderer"));
        }
    }

    public static class NameRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch speedSearch) {
            if (speedSearch == null) {
                NameRenderer.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ApkEntry entry;
            if (tree == null) {
                NameRenderer.$$$reportNull$$$0(1);
            }
            if ((entry = ApkEntry.fromNode(value)) == null) {
                if (value instanceof LoadingNode) {
                    this.append(value.toString());
                }
                return;
            }
            VirtualFile file = entry.getFile();
            this.setIcon(NameRenderer.getIconFor(file));
            SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)entry.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
        }

        @NotNull
        private static Icon getIconFor(@NotNull VirtualFile file) {
            if (file == null) {
                NameRenderer.$$$reportNull$$$0(2);
            }
            String fileName = file.getName();
            if (!file.isDirectory()) {
                if (fileName == "AndroidManifest.xml") {
                    Icon icon = AndroidIcons.ManifestFile;
                    if (icon == null) {
                        NameRenderer.$$$reportNull$$$0(3);
                    }
                    return icon;
                }
                if (fileName.endsWith(".dex")) {
                    Icon icon = AllIcons.FileTypes.JavaClass;
                    if (icon == null) {
                        NameRenderer.$$$reportNull$$$0(4);
                    }
                    return icon;
                }
                Icon ftIcon = file.getFileType().getIcon();
                Icon icon = ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
                if (icon == null) {
                    NameRenderer.$$$reportNull$$$0(5);
                }
                return icon;
            }
            if (fileName.equals("res")) {
                Icon icon = AllIcons.Modules.ResourcesRoot;
                if (icon == null) {
                    NameRenderer.$$$reportNull$$$0(6);
                }
                return icon;
            }
            Icon icon = AllIcons.Modules.SourceFolder;
            if (icon == null) {
                NameRenderer.$$$reportNull$$$0(7);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkViewPanel$NameRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkViewPanel$NameRenderer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIconFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FutureCallBackAdapter<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(@NotNull Throwable t) {
            if (t == null) {
                FutureCallBackAdapter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/apk/viewer/ApkViewPanel$FutureCallBackAdapter", "onFailure"));
        }
    }

    public static interface Listener {
        public void selectionChanged(@Nullable ApkEntry var1);

        public void selectApkAndCompare();
    }
}

