/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.android.tools.idea.apk.viewer.diff.ApkDiffParser;
import com.android.tools.idea.editors.NinePatchEditorProvider;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    private final Project myProject;
    private final VirtualFile myBaseFile;
    private final VirtualFile myRoot;
    private final ApkViewPanel myApkViewPanel;
    private JBSplitter mySplitter;
    private ApkFileEditorComponent myCurrentEditor;

    public ApkEditor(@NotNull Project project, @NotNull VirtualFile baseFile, @NotNull VirtualFile root) {
        if (project == null) {
            ApkEditor.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            ApkEditor.$$$reportNull$$$0(1);
        }
        if (root == null) {
            ApkEditor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myBaseFile = baseFile;
        this.myRoot = root;
        this.mySplitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.mySplitter.setName("apkViwerContainer");
        this.myApkViewPanel = new ApkViewPanel(new ApkParser(baseFile, root));
        this.myApkViewPanel.setListener(this);
        this.mySplitter.setFirstComponent(this.myApkViewPanel.getContainer());
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
    }

    @Override
    public void selectionChanged(@Nullable ApkEntry entry) {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
        }
        VirtualFile file = entry == null ? null : entry.getFile();
        this.myCurrentEditor = this.getEditor(file);
        this.mySplitter.setSecondComponent(this.myCurrentEditor.getComponent());
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(file -> ApkFileSystem.EXTENSIONS.contains(file.getExtension()));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.myProject, null);
        if (file2 == null) {
            return;
        }
        VirtualFile newApk = ApkFileSystem.getInstance().getRootByLocal(file2);
        assert (newApk != null);
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(this.myRoot.getName() + " vs " + newApk.getName());
        ApkDiffParser parser = new ApkDiffParser(this.myRoot, newApk);
        ApkDiffPanel panel = new ApkDiffPanel(parser);
        builder.setCenterPanel(panel.getContainer());
        builder.setPreferredFocusComponent(panel.getPreferredFocusedComponent());
        builder.show();
    }

    @NotNull
    public JComponent getComponent() {
        JBSplitter jBSplitter = this.mySplitter;
        if (jBSplitter == null) {
            ApkEditor.$$$reportNull$$$0(3);
        }
        return jBSplitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myApkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = this.myBaseFile.getName();
        if (string == null) {
            ApkEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ApkEditor.$$$reportNull$$$0(5);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ApkEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ApkEditor.$$$reportNull$$$0(7);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
    }

    @NotNull
    private ApkFileEditorComponent getEditor(@Nullable VirtualFile file) {
        if (file == null) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                ApkEditor.$$$reportNull$$$0(8);
            }
            return emptyPanel;
        }
        if (ApkFileSystem.getInstance().isArsc(file)) {
            byte[] arscContent;
            try {
                arscContent = file.contentsToByteArray();
            }
            catch (IOException e) {
                EmptyPanel emptyPanel = new EmptyPanel();
                if (emptyPanel == null) {
                    ApkEditor.$$$reportNull$$$0(9);
                }
                return emptyPanel;
            }
            ArscViewer arscViewer = new ArscViewer(arscContent);
            if (arscViewer == null) {
                ApkEditor.$$$reportNull$$$0(10);
            }
            return arscViewer;
        }
        if ("dex".equals(file.getExtension())) {
            DexFileViewer dexFileViewer = new DexFileViewer(file);
            if (dexFileViewer == null) {
                ApkEditor.$$$reportNull$$$0(11);
            }
            return dexFileViewer;
        }
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file);
        if (!providers.isPresent()) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                ApkEditor.$$$reportNull$$$0(12);
            }
            return emptyPanel;
        }
        final FileEditor editor = providers.get().createEditor(this.myProject, file);
        ApkFileEditorComponent apkFileEditorComponent = new ApkFileEditorComponent(){

            @Override
            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = editor.getComponent();
                if (jComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            public void dispose() {
                Disposer.dispose((Disposable)editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor$1", "getComponent"));
            }
        };
        if (apkFileEditorComponent == null) {
            ApkEditor.$$$reportNull$$$0(13);
        }
        return apkFileEditorComponent;
    }

    @NotNull
    private Optional<FileEditorProvider> getFileEditorProviders(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            Optional<FileEditorProvider> optional = Optional.empty();
            if (optional == null) {
                ApkEditor.$$$reportNull$$$0(14);
            }
            return optional;
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, file);
        Optional<FileEditorProvider> optional = Arrays.stream(providers).filter(fileEditorProvider -> !(fileEditorProvider instanceof NinePatchEditorProvider)).findFirst();
        if (optional == null) {
            ApkEditor.$$$reportNull$$$0(15);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

